<?php
session_start(); // ✅ Always start session

include("db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ✅ Safe defaults in case session not set
$userName = $_SESSION['user_name'] ?? 'System';
$userRole = $_SESSION['user_role'] ?? 'Admin';
$outlet_name = $_SESSION['outlet_name'] ?? 'Main Outlet';
$outlet_address = $_SESSION['outlet_address'] ?? 'Head Office';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor"])) {
    $date_time = date("Y-m-d");

    // creditor values
    $cr_name       = $_POST["cr_name"] ?? '';
    $cr_nickname   = $_POST["cr_nickname"] ?? '';
    $cr_address    = $_POST["cr_address"] ?? '';
    $phone_number  = $_POST["phone_number"] ?? '';
    $cr_id         = $_POST["cr_id"] ?? '';
    $Route         = $_POST["route"] ?? '';
    $ShopName      = $cr_name ?? '';
    $Booker        = $_POST["booker"] ?? '';
    $status        = 'Customer';

    if (!$connection) {
        die("Database connection failed: " . mysqli_connect_error());
    }

    // ✅ insert into credit_note
    $stmt = $connection->prepare("
        INSERT INTO credit_note 
        (cr_name, cr_nickname, cr_address, phone_number, cr_id, shop_name, route, booker, user_name, user_role, outlet_name, outlet_address, date_time) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        die("Error preparing statement: " . $connection->error);
    }

    $stmt->bind_param(
        "sssssssssssss",
        $cr_name,
        $cr_nickname,
        $cr_address,
        $phone_number,
        $cr_id,
        $ShopName,
        $Route,
        $Booker,
        $userName,
        $userRole,
        $outlet_name,
        $outlet_address,
        $date_time
    );

    if ($stmt->execute()) {
        echo '<script>alert("Customer added successfully!"); window.location.href="credits.php";</script>';
    } else {
        die("Error inserting credit_note: " . $stmt->error);
    }

    $stmt->close();
}

// ✅ Handle AJAX request to get route for selected shop
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == 'get_route') {
    $shop_name = mysqli_real_escape_string($connection, $_POST['shop_name']);
    
    $query = mysqli_query($connection, "SELECT TRIM(route) as route1 FROM shop_u WHERE shop_name = '$shop_name'");

    if ($row = mysqli_fetch_assoc($query)) {
        echo $row['route1'];  // Send route back as response
    } else {
        echo "Not Found";  // Handle case when no route is found
    }
    exit; // Stop further execution
}

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Distribution Software</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.form-control, .btn{
	  	font-weight:700;
	  	}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container">
        <div class="row">
            <br>
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Add Customer Ledger</h3>
                
            </div>
            <div class="col-sm-3">
               
            </div>
        </div>
        <div class="row">
          <div class="col-sm-2"></div>
          <div class="col-sm-8">
           
          </div>
          <div class="col-sm-2"></div>
        </div>
    </div><br />
   
    <div class="container">
        <form action="credits.php" method="post" enctype="multipart/form-data">
    <div class="row">
        <div class="col-sm-1"></div>
        <div class="col-sm-5">
            <div class="form-group">
                <label>Creditor ID</label>
                <input class="form-control mb-3" type="text" name="cr_id" >
            </div>
            
            <div class="form-group">
                <label>Shop</label>
                <input type="text" class="form-control mb-3" name="cr_name" style="font-weight:700; color:#000;">
                   
            </div>

            <div class="form-group">
                
                <input class="form-control mb-3" type="hidden" name="shop_name" value="0">
            </div>

            <div class="form-group">
                <label>Shop Owner Name</label>
                <input class="form-control mb-3" type="text" name="cr_nickname">
            </div>
            <div class="form-group">
                <label>Route</label>
                <input class="form-control" type="text" name="route"   style="color:#000; font-weight:700;" >
            </div>
        </div>

        <div class="col-sm-5">
            <div class="form-group">
                <label>Creditor Address</label>
                <input class="form-control mb-3" type="text" name="cr_address">
            </div>

            <div class="form-group">
                <label>Phone Number</label>
                <input class="form-control mb-3" type="text" name="phone_number">
            </div>
                
            <div class="form-group">
                <label>Booker</label>
                <input type="text" class="form-control mb-3" name="booker"  style="color:#000; font-weight:700;">
                    
            </div>

            <button type="submit" class="btn btn-dark form-control" name="creditor" style="margin-top:30px;">Enter</button>
        </div>
        <div class="col-sm-1"></div>
    </div>
</form>
      
           
    
            
                <!-- /.container-fluid -->

            </div>
            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

      
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
<script>
$(document).ready(function() {
    $('#shop_name').change(function() {
        var shop_name = $(this).val();
        if (shop_name !== '') {
            $.ajax({
                type: "POST",
                url: "", // Same page URL
                data: { action: 'get_route', shop_name: shop_name }, // Added 'action' to differentiate AJAX request
                success: function(response) {
                    var trimmedResponse = response.trim(); // Trim the response to remove extra spaces
                    $('#route').val(trimmedResponse); // Update the route field with trimmed response
                },
                error: function() {
                    $('#route').val('Error fetching route'); // Error handling
                }
            });
        } else {
            $('#route').val('');
        }
    });
});
</script>
</body>

</html>