<?php
include("../db/cn.php");
include("common/tx.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_GET['inv_id'])) {
    die("Order ID not provided.");
}

$orderId = $_GET['inv_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantities = $_POST['quantities'];
    $prices = $_POST['prices'];
    $discounts = $_POST['discounts'];
    $exper = $_POST['ex_percentages'];
    $whper = $_POST['wh_percentages'];
    $totals = $_POST['total_amount'];

    $grandTotal = 0;

    foreach ($quantities as $id => $qty) {
        $price = $prices[$id];
        $discount = $discounts[$id]; 
        $experG = $exper[$id]; 
        $whperG = $whper[$id]; 
        $total = $totals[$id]; 

        // ✅ Net Amount Calculation
        $afterDiscount = $price - ($discount / 100) * $price;
        $afterEx = $afterDiscount - ($experG / 100) * $afterDiscount;
        $afterWh = $afterEx + ($whperG / 100) * $afterDiscount;
        $netAmount = $afterWh * $qty;

        $grandTotal += $netAmount;

        // ✅ Update each row
        $updateItem = "UPDATE purchase 
            SET product_quantity = '$qty', 
                product_price = '$price', 
                discount = '$discount', 
                net_amount = '$netAmount',
                ex_percentage = '$experG',
                wh_percentage = '$whperG',
                total_amount = '$total'
            WHERE inv_id = '$orderId' AND id = '$id'";

        if (!mysqli_query($connection, $updateItem)) {
            die("Update failed: " . mysqli_error($connection));
        }
    }

    // ✅ Update grand total (optional)
    $updateDiscountAmount = "UPDATE purchase
        SET discount_amount = '$grandTotal'
        WHERE inv_id = '$orderId'";

    if (!mysqli_query($connection, $updateDiscountAmount)) {
        die("Failed to update discount_amount: " . mysqli_error($connection));
    }

    echo "<script>alert('Invoice updated successfully!'); window.location.href='purchase_detail_v.php';</script>";
    exit();
}

// ✅ Fetch order details
$result = mysqli_query($connection, "SELECT * FROM purchase WHERE inv_id = '$orderId'");
if (mysqli_num_rows($result) == 0) {
    die("Order not found.");
}
$orderRows = [];
while ($row = mysqli_fetch_assoc($result)) {
    $orderRows[] = $row;
}
ob_end_flush();
?>

<!DOCTYPE html>
<html>
<head>
    <title><?php echo $tx; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
    <h3>Edit Invoice: <?php echo htmlspecialchars($orderId); ?></h3>
    <form method="POST" id="editForm">
        <table class="table text-center table-sm" style="font-size:14px;">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Price(Rs)</th>
                    <th>Discount(%)</th>
                    <th>Ex.Discount(%)</th>
                    <th>WH(%)</th>
                    <th>Total(Rs)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orderRows as $row): ?>
                <tr>
                    <td><?php echo $row['product_name']; ?></td>
                    <td>
                        <input type="number" name="quantities[<?php echo $row['id']; ?>]" 
                               class="form-control qty" 
                               value="<?php echo $row['product_quantity']; ?>" min="1">
                    </td>
                    <td>
                        <input type="number" name="prices[<?php echo $row['id']; ?>]" 
                               class="form-control price" 
                               value="<?php echo $row['product_price']; ?>" step="0.01">
                    </td>
                    <td>
                        <input type="number" name="discounts[<?php echo $row['id']; ?>]" 
                               class="form-control discount" 
                               value="<?php echo $row['discount']; ?>" step="0.01">
                    </td>
                    <td>
                        <input type="number" name="ex_percentages[<?php echo $row['id']; ?>]" 
                               class="form-control ex" 
                               value="<?php echo $row['ex_percentage']; ?>" step="0.01">
                    </td>
                    <td>
                        <input type="number" name="wh_percentages[<?php echo $row['id']; ?>]" 
                               class="form-control wh" 
                               value="<?php echo $row['wh_percentage']; ?>" step="0.01">
                    </td>
                    <td>
                        <input type="number" name="total_amount[<?php echo $row['id']; ?>]" 
                               class="form-control total" 
                               value="<?php echo $row['total_amount']; ?>" step="0.01" readonly>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="text-end">
            <p><strong>Sub:</strong> Rs <span id="subtotal">0</span></p>
            <p><strong>Total:</strong> Rs <span id="grandtotal">0</span></p>
        </div>

        <button type="submit" class="btn btn-success">Update Order</button>
        <a href="purchase_detail_v.php" class="btn btn-secondary">Cancel</a>
    </form>


     <script>
function calculateRowTotal(row) {
    const qty = parseFloat(row.querySelector(".qty").value) || 0;
    const price = parseFloat(row.querySelector(".price").value) || 0;
    const discount = parseFloat(row.querySelector(".discount").value) || 0;
    const ex = parseFloat(row.querySelector(".ex").value) || 0;
    const wh = parseFloat(row.querySelector(".wh").value) || 0;

    // Step 1: Discount on retail price
    const afterDiscount = price - (discount / 100) * price;

    // Step 2: Apply EX (minus)
    const afterEx = afterDiscount - (ex / 100) * afterDiscount;

    // Step 3: Apply WH (plus)
    const afterWh = afterEx + (wh / 100) * afterDiscount;

    // Step 4: Multiply by quantity
    const tradePrice = afterWh * qty;

    // Update total input
    row.querySelector(".total").value = tradePrice.toFixed(2);

    return tradePrice;
}

function calculateAllRows() {
    let subtotal = 0;
    document.querySelectorAll("tbody tr").forEach(row => {
        subtotal += calculateRowTotal(row);
    });

    // Update totals
    document.getElementById("subtotal").innerText = subtotal.toFixed(2);
    document.getElementById("grandtotal").innerText = subtotal.toFixed(2);
}

function attachEvents() {
    document.querySelectorAll("tbody tr").forEach(row => {
        row.querySelectorAll("input").forEach(input => {
            input.addEventListener("input", calculateAllRows);
        });
    });

    // Initial calculation on page load
    calculateAllRows();
}

window.addEventListener("DOMContentLoaded", attachEvents);
</script>

 
    
</body>
</html>
