<?php
include('db/cn.php');

// Fetch products
$query = mysqli_query($connection, "SELECT product_id, product_name, retail_price FROM products");
if (!$query) {
    die("Query failed: " . mysqli_error($connection));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>WholeSale</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .label-card {
            width: 250px;
            border: 1px dashed #333;
            padding: 15px;
            margin: 10px;
            text-align: center;
        }
        .barcode {
            font-family: 'Courier New', monospace;
            font-size: 18px;
            letter-spacing: 3px;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-4">Product Labels</h2>
    <div class="row">
        <?php while($row = mysqli_fetch_assoc($query)) { ?>
            <div class="col-md-3 col-sm-4 col-6">
                <div class="label-card">
                    <div class="barcode">*<?php echo $row['product_id']; ?>*</div>
                    <h6><?php echo htmlspecialchars($row['product_name']); ?></h6>
                    <p>Price: <?php echo number_format($row['retail_price'], 2); ?></p>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
</body>
</html>
