<?php
include("../db/cn.php");
ini_set('display_errors', 1);
error_reporting(E_ALL);

$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $pre = $order['pre_amount'];
        $close = $order['grand_amount'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice #<?= htmlspecialchars($orderId ?? '') ?></title>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Quicksand', sans-serif;
    color: #333;
    background: #fff;
    width: 210mm;
    margin: 0 auto;
    padding: 30px;
}
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 5px solid #0A4657;
    padding-bottom: 15px;
}
.header-left img {
    width: 70px;
    height: auto;
}
.header-right {
    text-align: right;
}
.header-right h2 {
    color: #0A4657;
    font-size: 22px;
    margin: 0;
}
.header-right p {
    font-size: 14px;
    margin: 2px 0;
}
.section {
    display: flex;
    justify-content: space-between;
    margin-top: 25px;
    font-size: 14px;
}
.section div {
    width: 48%;
}
.section h3 {
    color: #0A4657;
    margin-bottom: 5px;
    font-size: 15px;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 30px;
    font-size: 14px;
}
th {
    background: #0A4657;
    color: #fff;
    padding: 8px;
    text-align: center;
}
td {
    padding: 6px;
    text-align: center;
    border-bottom: 1px solid #ddd;
}
.summary {
    width: 40%;
    float: right;
    margin-top: 20px;
}
.summary td {
    padding: 6px 10px;
    font-size: 14px;
}
.summary tr:last-child td {
    background: #711616;
    color: #fff;
    font-weight: 600;
    font-size: 15px;
}
.footer {
    clear: both;
    margin-top: 60px;
    font-size: 12px;
    color: #555;
}
.footer p {
    margin: 4px 0;
}
.no-print {
    text-align: center;
    margin-top: 25px;
}
button {
    background: #0A4657;
    color: #fff;
    border: none;
    padding: 8px 18px;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 600;
}
button:hover {
    background: #0A4657;
}
@media print {
    .no-print { display: none; }
    body { padding: 0; margin: 0; }
}
</style>
</head>
<body>
    <div class="header">
        <div class="header-left">
            <img src="../img/logo231.png" alt="Logo">
        </div>
        <div class="header-right">
            <h2>INVOICE</h2>
            <p><strong>Invoice #:</strong> <?= htmlspecialchars($orderId ?? '') ?></p>
            <p><strong>Date:</strong> <?= htmlspecialchars($dateTime ?? '') ?></p>
            <p><strong>Cashier:</strong> <?= htmlspecialchars($loginUser ?? '') ?></p>
        </div>
    </div>

    <div class="section">
        <div style="width: 20%;">
            <h3>Bill To</h3>
            <p><?= htmlspecialchars($customerName ?? '') ?><br>
               <?= htmlspecialchars($customerPhone ?? '') ?><br>
               <strong>Payment:</strong> <?= htmlspecialchars($paidBy ?? '') ?>
            </p>
        </div>
        <div>
            <h3>From</h3>
            <p><?= htmlspecialchars($outletName ?? 'Wholesale') ?><br>
               <?= htmlspecialchars($outletAddress ?? 'Tufail Shaheed Road, Sahiwal') ?><br>
               Phone: 0309-XXXXXXX
            </p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Item</th>
                <th>Qty</th>
                <th>Price</th>
                <th>SubTotal</th>
                <th>Disc %</th>
                <th>Ex %</th>
                <th>Wh %</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $i = 1; foreach ($orderDetails as $order): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($order['product_name'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['product_quantity'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['product_price'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['total_amount'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['discount'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['ex_percentage'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['wh_percentage'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['net_amount'] ?? '') ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <table class="summary">
        <tr>
            <td><strong>Subtotal</strong></td>
            <td>Rs <?= htmlspecialchars($discountedAmount ?? '0') ?> /-</td>
        </tr>
        <tr>
            <td><strong>Previous Balance</strong></td>
            <td>Rs <?= htmlspecialchars($pre ?? '0') ?> /-</td>
        </tr>
        <tr>
            <td><strong>Tax</strong></td>
            <td>Rs <?= htmlspecialchars($taxAmount ?? '0') ?> /-</td>
        </tr>
        <tr>
            <td><strong>Discount</strong></td>
            <td><?= htmlspecialchars($discountPer ?? '0') ?>%</td>
        </tr>
        <tr>
            <td><strong>Total Due</strong></td>
            <td>Rs <?= htmlspecialchars($close ?? '0') ?> /-</td>
        </tr>
        <tr>
            <td><strong>Amount Received</strong></td>
            <td>Rs <?= htmlspecialchars($cashAmount ?? '0') ?> /-</td>
        </tr>
        <tr>
            <td><strong>Balance Remaining</strong></td>
            <td>Rs <?= htmlspecialchars($changeAmount ?? '0') ?> /-</td>
        </tr>
    </table>

    <div class="footer">
        <p><strong>Terms & Conditions:</strong></p>
        <p>• Exchanges are accepted within 7 days from the date of purchase.</p>
        <p>• Items must be unused and in their original packaging.</p>
        <p>• Please retain this invoice for all exchanges or returns.</p>
        <p style="margin-top:15px;font-weight:600;">Thank you for your business!</p>
    </div>

    <div class="no-print">
        <button onclick="window.print()">Print Invoice</button>
        <button onclick="window.location.href='mainpos.php'">Exit</button>
    </div>
</body>
</html>
