<?php
include("../db/cn.php");
ini_set('display_errors', 1);
error_reporting(E_ALL);

$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $pre = $order['pre_amount'];
        $close = $order['grand_amount'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice #<?= htmlspecialchars($orderId ?? '') ?></title>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600&display=swap" rel="stylesheet">
<style>
@page {
    size: A5;
    margin: 10mm;
}
body {
    font-family: 'Quicksand', sans-serif;
    color: #333;
    background: #fff;
    width: 198mm;
    height: 1400mm;
    margin: 0 auto;
    padding: 10mm;
    box-sizing: border-box;
}
.header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #0A4657;
    padding-bottom: 6px;
}
.header-left img {
    width: 45px;
    height: auto;
}
.header-right {
    text-align: right;
}
.header-right h2 {
    color: #0A4657;
    font-size: 18px;
    margin: 0;
}
.header-right p {
    font-size: 11px;
    margin: 1px 0;
}
.section {
    display: flex;
    justify-content: space-between;
    margin-top: 10px;
    font-size: 11px;
}
.section div { width: 48%; }
.section h3 {
    color: #0A4657;
    margin-bottom: 2px;
    font-size: 12px;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 8px;
    font-size: 11px;
}
th {
    background: #0A4657;
    color: #fff;
    padding: 4px;
    text-align: center;
}
td {
    padding: 3px;
    text-align: center;
    border-bottom: 1px solid #ddd;
}
.summary {
    width: 60%;
    float: right;
    margin-top: 10px;
    font-size: 11px;
}
.summary td {
    padding: 4px 6px;
}
.summary tr:last-child td {
    background: #711616;
    color: #fff;
    font-weight: 600;
    font-size: 12px;
}
.footer {
    clear: both;
    margin-top: 15px;
    font-size: 10px;
    color: #555;
}
.footer p { margin: 2px 0; }
.no-print {
    text-align: center;
    margin-top: 10px;
}
button {
    background: #0A4657;
    color: #fff;
    border: none;
    padding: 5px 12px;
    border-radius: 4px;
    cursor: pointer;
    font-weight: 700;
    font-size: 11px;
}
@media print {
    .no-print { display: none; }
    body { margin: 0; padding: 0; }
}
</style>
</head>
<body>
    <div class="header">
        <div class="header-left">
            <img src="../img/logo231.png" alt="Logo">
        </div>
        <div class="header-right">
            <h2>INVOICE</h2>
            <p><strong>#:</strong> <?= htmlspecialchars($orderId ?? '') ?></p>
            <p><strong>Date:</strong> <?= htmlspecialchars($dateTime ?? '') ?></p>
            <p><strong>Cashier:</strong> <?= htmlspecialchars($loginUser ?? '') ?></p>
        </div>
    </div>

    <div class="section">
        <div>
            <h3>Bill To</h3>
            <p><?= htmlspecialchars($customerName ?? '') ?><br>
               <?= htmlspecialchars($customerPhone ?? '') ?><br>
               <strong>Payment:</strong> <?= htmlspecialchars($paidBy ?? '') ?></p>
        </div>
        <div>
            <h3>From</h3>
            <p><?= htmlspecialchars($outletName ?? 'Wholesale') ?><br>
               <?= htmlspecialchars($outletAddress ?? 'Tufail Shaheed Road, Sahiwal') ?><br>
               Phone: 0309-XXXXXXX</p>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Item</th>
                <th>Qty</th>
                <th>Price</th>
                <th>SubTotal</th>
                <th>Disc %</th>
                <th>Ex %</th>
                <th>Wh %</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php $i = 1; foreach ($orderDetails as $order): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($order['product_name'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['product_quantity'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['product_price'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['total_amount'] ?? '') ?></td>
                <td><?= htmlspecialchars($order['discount'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['ex_percentage'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['wh_percentage'] ?? '0') ?></td>
                <td><?= htmlspecialchars($order['net_amount'] ?? '') ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <table class="summary">
        <tr><td><strong>Subtotal</strong></td><td>Rs <?= htmlspecialchars($discountedAmount ?? '0') ?> /-</td></tr>
        <tr><td><strong>Prev. Balance</strong></td><td>Rs <?= htmlspecialchars($pre ?? '0') ?> /-</td></tr>
        <tr><td><strong>Discount</strong></td><td><?= htmlspecialchars($discountPer ?? '0') ?>%</td></tr>
        <tr><td><strong>Total Due</strong></td><td>Rs <?= htmlspecialchars($close ?? '0') ?> /-</td></tr>
        <tr><td><strong>Received</strong></td><td>Rs <?= htmlspecialchars($cashAmount ?? '0') ?> /-</td></tr>
        <tr><td><strong>Balance</strong></td><td>Rs <?= htmlspecialchars($changeAmount ?? '0') ?> /-</td></tr>
    </table>

    <div class="footer">
        <p><strong>Terms:</strong> Exchange within 7 days if unused and in original packaging.</p>
        <p>Please retain this invoice for any return.</p>
        <p style="margin-top:8px;font-weight:600;">Thank you for your business!</p>
    </div>

    <div class="no-print">
        <button onclick="window.print()">Print</button>
        <button onclick="window.location.href='mainpos.php'">Exit</button>
    </div>
</body>
</html>
