<?php
include'db/cn.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Get the selected booker and date from the form
$booker = isset($_GET['booker']) ? mysqli_real_escape_string($connection, $_GET['booker']) : '';
$date = isset($_GET['date']) ? mysqli_real_escape_string($connection, $_GET['date']) : '';

// Build the query with dynamic conditions
$query = "
    SELECT 
        DATE(date_time) as date_time, 
        product_name, 
        SUM(product_quantity) AS total_quantity, 
        product_price 
    FROM 
        log_user_sales 
    WHERE 
        1=1
";

if (!empty($booker)) {
    $query .= " AND customer_type = '$booker'";
}

if (!empty($date)) {
    $query .= " AND DATE(date_time) = '$date'";
}

$query .= "
    GROUP BY 
        DATE(date_time), product_name, product_price
    ORDER BY 
        date_time, product_name
";

$result = mysqli_query($connection, $query);

if (!$result) {
    die("Query Error: " . mysqli_error($connection));
}
?>

<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Distribution Software</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>


body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.text-primary{
	  	
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>

<div class="container">
    <div class="row">
        <div class="col-sm-5">
            <h3 style="font-weight:700;color:#000;">Booker Wise Sale Report</h3>
        </div>
    </div>
    <br>

   <form action="" method="GET">
    <div class="row">
        <div class="col-sm-3">
            <div class="form-group">
                <label>Select Booker</label>
                <select class="form-control" name="booker" onchange="this.form.submit()">
                    <option value="">Select</option>
                    <?php
                    $b = mysqli_query($connection, "SELECT DISTINCT booker FROM credit_note");
                    while ($cr = mysqli_fetch_array($b)) {
                        $selected = ($cr["booker"] == $booker) ? "selected" : "";
                        echo "<option value='{$cr["booker"]}' $selected>{$cr["booker"]}</option>";
                    }
                    ?>
                </select>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="form-group">
                <label>Date</label>
                <input type="date" class="form-control" name="date" value="<?= htmlspecialchars($date) ?>">
            </div>
        </div>
        <div class="col-sm-3">
            <button class="btn btn-dark" type="submit" style="margin-top:30px;">Filter</button>
            <a href="report_booker.php">
                <button class="btn btn-dark" type="button" style="margin-top:30px;">
                    <i class="fas fa-sync fa-1x"></i>
                </button>
            </a>
        </div>
    </div>
</form>
    <div class="row">
        <table class="table table-striped table-hover text-center">
            <thead class="bg-dark text-white">
                <tr>
                    <th>Date</th>
                    <th>Product Name</th>
                    <th>Total Quantity</th>
                    <th>Price</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>
                                <td>{$row['date_time']}</td>
                                <td>{$row['product_name']}</td>
                                <td>{$row['total_quantity']}</td>
                                <td>{$row['product_price']}</td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='4'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>


            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>


   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
<script>
$(document).ready(function(){
    $("#filterButton").click(function(){
        var customer_name = $("select[name='customer_name']").val();
        var route = $("select[name='route']").val();
        var booker = $("select[name='booker']").val();
        var date = $("input[name='date']").val();
        
        $.ajax({
            url: "report_cus.php",
            type: "GET",
            data: {customer_name: customer_name, route: route, booker: booker, date: date},
            success: function(data) {
                $("#reportTable").html($(data).find("#reportTable").html());
            }
        });
    });
});
</script>

</body>

</html>