<?php
include("../db/cn.php");
ob_start();

// Ensure session variables exist
if(isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

// Fetch filter values
$expHead = isset($_GET["exp_head"]) ? trim($_GET["exp_head"]) : "";
$startDate = isset($_GET["start_date"]) ? trim($_GET["start_date"]) : "";
$endDate = isset($_GET["end_date"]) ? trim($_GET["end_date"]) : "";

// Construct SQL query with optional filters
$sql = "SELECT * FROM incash WHERE 1=1"; 

if (!empty($expHead)) {
    $sql .= " AND name_detail = '" . mysqli_real_escape_string($connection, $expHead) . "'";
}

if (!empty($startDate)) {
    $sql .= " AND date_time >= '" . mysqli_real_escape_string($connection, $startDate) . "'";
}

if (!empty($endDate)) {
    $sql .= " AND date_time <= '" . mysqli_real_escape_string($connection, $endDate) . "'";
}

$hasFilter = !empty($expHead) || !empty($startDate) || !empty($endDate);


$sql .= " ORDER BY date_time DESC";

if ($hasFilter) {
    $rec = mysqli_query($connection, $sql);
}

?>

<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
	/* Basic styling */
    .tab {
        display: none;
        padding: 20px;
    }
    .active {
        display: block;
    }
    .tab-buttons {
        display: flex;
    }
    .tab-button {
        cursor: pointer;
        padding: 10px 10px;
        background-color: #ffff;
        border: 1px solid #0A5064;
        border-radius: 5px 5px 0 0;
        margin-right: 5px;
		color:#212529;
    }
    .tab-button.active {
        background-color: #212529;
		color:#fff;
    }

    /* Background colors for tab content */
    #tab1 {
        background-color: #fff;
		color:#212529;
		padding:20px;
    }
    #tab2 {
        color:#212529;
		background-color: ;
    }
    #tab3 {
		color:#212529;
        background-color: ;
    }
    
    /* Custom styles for search bar */
    .search-container {
        display: flex;
        align-items: center;
       width:100%;
        margin: 2px auto;

        float:left;
	}

/* Updated hide class to apply to the overlay */
.sidebar.hide, .overlay.hide {
    transform: translateX(-100%);
}

    .search-input {
        width: 100%;
        padding: 10px 30px 10px 10px;
        /* Adjust padding to accommodate the icon */
        border: 1px solid #ccc;
        border-radius: 20px;
        font-size: 16px;
    }

    .search-icon {
        position: relative;
        left: -25px;
        /* Adjust the position of the icon */
        color: #aaa;
    }

    .search-icon i {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
    }
    label{
        font-weight:700;
        color:#000;
    }
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                     <?php include('common/log.php'); 
                    $exp = mysqli_query($connection,"select * from exp_head"); 
                     ?>
                </nav>
<br />

<div class="container">
        <div class="row">
            <div class="col-sm-12">
                <h3 style="color:#212529; font-weight:700;">Expense By Ledger Report </h3>
            </div>
        </div>
        <br>
        <form method="GET" action="report_exp.php">
                        <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label>Select Expense Head</label>
                                    <select name="exp_head" class="form-control">
                                        <option value="">Select</option>
                                        <?php
                                        $exp = mysqli_query($connection,"SELECT DISTINCT exp_head FROM exp_head");
                                        while($er = mysqli_fetch_array($exp)){
                                            echo '<option value="'.$er["exp_head"].'" '.($expHead == $er["exp_head"] ? "selected" : "").'>'.$er["exp_head"].'</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label>Start Date</label>
                                    <input type="date" name="start_date" class="form-control" value="<?php echo $startDate; ?>">
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label>End Date</label>
                                    <input type="date" name="end_date" class="form-control" value="<?php echo $endDate; ?>">
                                </div>
                            </div>
                            <div class="col-3">
                                <button type="submit" class="btn btn-dark" style="margin-top:30px;">Filter</button>
                                <a href="report_exp.php" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync fa-1x"></i></a>
                            </div>
                        </div>
                    </form>
    </div>
  
<?php if ($hasFilter): ?>
    <div class="container">
        <div class="row">
           <div class="col-sm-12">
               <table class="table table-striped table-hover text-center text-capitalize">
                   <thead class="bg-dark text-white">
                       <tr>
                           <th>Date</th>
                           <th>Expense Head</th>
                           <th>Paid By</th>
                           <th>Amount (Rs)</th>
                           <th>Recorded By</th>
                       </tr>
                   </thead>
                   <tbody>
                       <?php while($row = mysqli_fetch_array($rec)) { ?>
                           <tr>
                               <td><?php echo $row["date_time"]; ?></td>
                               <td><?php echo $row["name_detail"]; ?></td>
                               <td><?php echo $row["paid_by"]; ?></td>
                               <td><?php echo number_format($row["amount"], 2); ?></td>
                               <td><?php echo $row["login_user"]; ?></td>
                           </tr>
                       <?php } ?>
                   </tbody>
               </table>
           </div>
        </div>
    </div>
<?php else: ?>
    <div class="container">
        <div class="row">
            <div class="col-sm-12 text-center">
                <h5 class="text-white text-bold" style="background:#95ADB4;padding:20px; ">Please apply filters to generate the report.</h5>
            </div>
        </div>
    </div>
<?php endif; ?>


            </div>
           
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
<script>
    $(document).ready(function(){
        $("#searchInput").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("table tr").filter(function() {
                // Exclude header row from filtering
                if (!$(this).hasClass('header-row')) {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
                }
            });
        });
    });
    </script>

   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>