<?php
include("../db/cn.php");
ob_start();

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($connection->connect_error) {
    die("Connection failed: " . $connection->connect_error);
}

if (isset($_GET['query'])) {
    $query = $connection->real_escape_string($_GET['query']);
    $sql = "SELECT product_id, product_name, retail_price, rpperpack, tpperpack, trade_price, supplier, company, product_unit, total_quantity FROM products WHERE product_name LIKE '%$query%'";

    $result = $connection->query($sql);

    $suggestions = "";
    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-product-id='" . $row['product_id'] . "' data-product-quantity='" . $row['total_quantity'] . "'  data-product-Rquantity='" . $row['total_quantity'] . "' data-retail-price='" . $row['rpperpack'] . "' data-trade-price='" . $row['tpperpack'] . "' data-supplier='" . $row['supplier'] . "' data-company='" . $row['company'] . "' data-product-unit='" . $row['product_unit'] . "'>" . $row['product_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}

if (isset($_GET['customer_name'])) {
    $customerName = $connection->real_escape_string($_GET['customer_name']);
    $sql = "SELECT cr_name, cr_id, phone_number FROM credit_note WHERE cr_name LIKE '%$customerName%' LIMIT 5";

    $result = $connection->query($sql);
    $suggestions = "";

    while ($row = $result->fetch_assoc()) {
        $suggestions .= "<div class='dropdown-item' data-customer-name='" . $row['cr_name'] . "' data-customer-id='" . $row['cr_id'] . "' data-customer-phone='" . $row['phone_number'] . "'>" . $row['cr_name'] . "</div>";
    }

    echo $suggestions;
    exit;
}



if (isset($_GET['order_id'])) {

    // Get the search term
    $order_id = $_GET['order_id'];

    if (!empty($order_id)) {

        $stmt = $connection->prepare("SELECT order_id FROM log_user_sales WHERE order_id = ? GROUP BY order_id");
        $stmt->bind_param("s", $order_id);
        $stmt->execute();
        $result = $stmt->get_result();

        // Generate HTML output
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo '<div class="dropdown-item" data-order-id="' . $row['order_id'] . '">Order #' . $row['order_id'] . '</div>';
            }
        } else {
            echo '<div class="dropdown-item">No orders found</div>';
        }

        $stmt->close();
    }

    $connection->close();
    exit; 
}



$user = $userName;
$role = $userRole;
$outlet = $outlet_name;
$address = $outlet_address;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["bill"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);

    // Generate new inv_id
    $orderId = "OR" . str_pad(mt_rand(0, 99999), 5, "0", STR_PAD_LEFT);

    // ===================== GENERIC BILL NO =====================
    $result = $connection->query("SELECT bill_no FROM log_user_sales ORDER BY id DESC LIMIT 1");
    if ($result && $row = $result->fetch_assoc()) {
        $lastBill = (int)$row['bill_no'];
    } else {
        $lastBill = 0;
    }
    $newBill = $lastBill + 1;
    $billNo  = str_pad($newBill, 4, "0", STR_PAD_LEFT);
    // ============================================================

    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $r_order_id = $_POST["r_order_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = (float)$product['tradePrice'];
        $productQuantity = (int)$product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = $tradePrice * $productQuantity;
        $tp = $sale_cost;

        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            bill_no,   -- NEW COLUMN
            r_order_id,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$billNo',   -- NEW VALUE
            '$r_order_id',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";

        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        // Update product quantity
        $updateSql = "UPDATE products 
                      SET total_quantity = total_quantity - $productQuantity, 
                          total_amount = total_amount + $sale_cost 
                      WHERE product_id = '$productId'";

        if ($connection->query($updateSql) !== TRUE) {
            throw new Exception("Error updating product quantity: " . $connection->error);
        }
    }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'printpos.php?order_id=$orderId&bill_no=$billNo';</script>";
}




if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["refund"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $paidBy = $_POST["method"];
    $status = 'Refund';
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
    $r_order_id = $_POST["r_order_id"];
    $date_time = date("Y-m-d");
    $orderId = $r_order_id;

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        
        // Calculate the sale cost to add to total_amount on refund
        $refundAmount = $tradePrice * $productQuantity; // Total amount for the refund

        // Insert refund entry into log_user_sales
        $sql = "INSERT INTO log_user_sales (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            r_order_id,
            status,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '-$productQuantity', /* Negative quantity for logging refund in log_user_sales */
            '$productTotal',
            '',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$refundAmount',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$r_order_id',
            '$status',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";

        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }

        // Update the products table to increase both quantity and total_amount for the refund
        $updateSql = "UPDATE products 
                        SET total_quantity = total_quantity + $productQuantity, 
                            total_amount = total_amount + $refundAmount 
                        WHERE product_id = '$productId'";

        if ($connection->query($updateSql) !== TRUE) {
            throw new Exception("Error updating product quantity: " . $connection->error);
        }
    }

    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["hold"])) {
    if ($connection->connect_error) {
        die("Connection failed: " . $connection->connect_error);
    }

    $productData = json_decode($_POST['productData'], true);
    $orderId = uniqid("ORDER");
    $paidBy = $_POST['method'];
    $discount_amount = $_POST["bill_amount"];
    $discounted = $_POST["discount_amount"];
    $discount_per = $_POST["discount_percent"];
    $cash_amount = $_POST["cash_received"];
    $change_amount = $_POST["cash_return"];
    $customerName = $_POST["customer_name"];
    $customerPhone = $_POST["customer_phone"];
    $customer_type = $_POST["customer_type"];
    $customer_id = $_POST["customer_id"];
	$r_order_id = $_POST["r_order_id"];
    $date_time = date("Y-m-d");

    foreach ($productData as $product) {
        $productId = $product['productId'];
        $productName = $product['description'];
        $productPrice = $product['pricePerUnit'];
        $tradePrice = $product['tradePrice'];
        $productQuantity = $product['quantity'];
        $productTotal = $product['totalPrice'];
        $discount = $product['discountPercentage'];
        $tax = $product['tax'];
        $netAmount = $product['netAmount'];
        $supplierName = $product['supplier'];
        $company = $product['company'];
        $sale_cost = (int)$tradePrice * (int)$productQuantity;
       
        $sql = "INSERT INTO pay_hold (
            product_id,
            supplier_name,
            company,
            product_name,
            product_price,
            trade_price,
            product_quantity,
            product_total,
            bonus,
            discount,
            tax,
            net_amount,
            total_amount,
            paid_by,
            sale_cost,
            customer_id,
            customer_type,
            customer_name,
            customer_phone,
            discount_amount,
            discounted,
            discount_per,
            cash_amount,
            change_amount,
            order_id,
            outlet_name,
            login_user,
            user_role,
            outlet_address,
            date_time
        ) VALUES (
            '$productId',
            '$supplierName',
            '$company',
            '$productName',
            '$productPrice',
            '$tradePrice',
            '$productQuantity',
            '$productTotal',
            '',
            '$discount',
            '$tax',
            '$netAmount',
            '$productTotal',
            '$paidBy',
            '$sale_cost',
            '$customer_id',
            '$customer_type',
            '$customerName',
            '$customerPhone',
            '$discount_amount',
            '$discounted',
            '$discount_per',
            '$cash_amount',
            '$change_amount',
            '$orderId',
            '$outlet',
            '$user',
            '$role',
            '$address',
            '$date_time'
        )";
        
        if ($connection->query($sql) !== TRUE) {
            echo "Error: " . $sql . "<br>" . $connection->error;
            ob_end_flush();
            exit;
        }
            
        }
   
    ob_end_clean();
    echo "<script type='text/javascript'>window.location.href = 'mainpos.php';</script>";
}
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>NEUROCARE</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
     <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
    font-family: 'Quicksand', sans-serif;
    
}
    
    
 #table-con {
    max-height: 390px; 
    overflow-y: auto; 
}
        .bg {
            background: linear-gradient(270deg, #060606, #0A4657);
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
        }
        .in_form {
            height: 30px;
            font-size: 13px;
            border-color: #0A5064;
        }
        label {
            font-size: 13.5px;
            font-weight: 700;
        }
        .input-group-text {
            font-weight: 600;
            font-size: 11px;
            width: 73px;
            display:
        }
        .dropdown-menu {
            max-height: 200px;
            overflow-y: auto;
            position: absolute;
            z-index: 1000;
            width: 100%;
        }
        .input-group {
            position: relative;
        }
		.dropdown-item.active, .dropdown-item:active {
    color: #fff;
    text-decoration: none;
    background-color: #0A5064;
}
.form-control{
    color:#000;
    font-weight:600;
}
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row bg">
        <div class="col-sm-3 " style="width:100%; height:69px;">
            <img src="../img/dash.png" style="margin-top:5px;" width="66" height="66">
        </div>
        <div class="col-sm-6">
        <h3 class="mb-4" style="color:#fff; font-weight:700; text-align:center; text-transform:uppercase;line-height:60px;">NEUROCARE</h3>
        
        </div>
        <div class="col-sm-3">
            <a href="addproduct.php" class="btn btn-light" style="margin-top:20px; float:right;" >Back</a>
        </div>
    </div>
</div>
<div class="container-fluid">
    <form action="mainpos.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-3" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Product</span>
                    </div>
                    <input type="text" class="form-control" id="productInput" placeholder="Start typing a product name..." autocomplete="off">
                    <div class="dropdown-menu" id="suggestions"></div>
                </div>
                <hr>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">R.Qty</span>
                    </div> 
                    <input type="text" id="re_quantity" name="re_quantity" class="form-control" placeholder="" readonly>
                </div>
                <hr>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Quantity</span>
                    </div>
                    <input type="text" id="quantity" name="quantity" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Price / Unit</span>
                    </div>
                    <input type="text" id="retail_price" name="retail_price" class="form-control" placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="total_amount" name="total_amount" class="form-control" placeholder="" readonly>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">-/ PKR</span>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Dis %</span>
                    </div>
                    <input type="text" id="percentage" name="percentage" class="form-control"  placeholder="">
                </div>
                  <div>
                    <div>
                        <!--<span class="input-group-text bg-dark text-white">Ex.%</span>-->
                    </div>
                    <input type="hidden" id="ex_percentage" name="ex_percentage" class="form-control"  placeholder="">
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-dark text-white">Total Price</span>
                    </div>
                    <input type="text" id="trade_price" name="trade_price" class="form-control" placeholder="" readonly>
                </div>
                <br>
                <button type="button" class="form-control btn btn-dark" id="makeEntry" style="color:#fff;">Make Entry</button>
                
                <!--<a href="view_hold.php"><button type="button" class="form-control btn btn-dark" >View Hold Bill</button></a>-->
                <hr>
                <button type="button" class="form-control btn btn-dark" onclick="location.reload();" style="color:#fff;">Refresh</button>
               
                    
            </div>
            <div class="col-sm-9">
                <div class="row" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                    <div class="">
                        <div class="form-group">
                         
                            <input type="hidden" class="form-control in_form" name="customer_type">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Name</label>
                            <input type="text" id="customer_name" name="customer_name" class="form-control in_form" autocomplete="off">
                            <div class="dropdown-menu" id="customer_suggestions"></div>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer Phone</label>
                            <input type="text" id="customer_phone" name="customer_phone" class="form-control in_form">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Customer ID</label>
                            <input type="text" id="customer_id" name="customer_id" class="form-control in_form">
                        </div>
                    </div>
                     <div class="col-sm-3">
    <div class="form-group">
        <label>Refund ID</label>
        <input type="text" id="r_order_id" name="r_order_id" class="form-control in_form">
        <div id="order_suggestions" class="dropdown-menu" style="display: none;"></div>
    </div>
</div>
                </div>
                <div class="row" style="background:#fff; padding:10px; border:1px solid #CCC;">
                    <div class="col-sm-12" style="height:400px;" id="table-con">
                        <table class="table table-borderless table-sm text-center" id="productsTable">
                            <tr class="text-white text-center" style="background:#0A4657;font-weight:700;">
                                <td>R.Qty</td>
                                <td>Item Code</td>
                                <td>Description</td>
                                <td>Qty</td>
                                <td>Unit Price</td>
                                <td>Amount</td>
                                <td>% Dis</td>
                                <td>Tax</td>
                                <td>Net Amount</td>
                                <td>Action</td>
                                <td>Edit</td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row" style="margin-top: -10px;">
                    <div class="col-sm-12" style="background:#F0F0F0; padding:10px; border:1px solid #CCC;">
                        <br>
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Total</label>
                                    <input type="number" id="total-input" name="total_input" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Bill Amount</label>
                                    <input type="text" id="bill-amount" name="bill_amount" class="form-control in_form input-height" required>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount Amount</label>
                                    <input type="number" id="discount_amount" name="discount_amount" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Discount %</label>
                                    <input type="number" id="discount_percent" name="discount_percent" class="form-control in_form input-height" readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Received</label>
                                    <input type="number" id="cash_received" name="cash_received" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Cash Return</label>
                                    <input type="number" id="cash_return" name="cash_return" class="form-control in_form input-height">
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>S.Tax(0%)</label>
                                    <input type="number" id="tax" name="tax" class="form-control in_form input-height"  readonly>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>Method</label>
                                    <select name="method" id="method" class="form-control in_form">
                                        <option value="cash">Cash</option>
                                        <option value="credit">Credit</option>
                                        <option value="bank1">Bank 1</option>
                                    <option value="bank2">Bank 2 </option>
                                    <option value="bank3">Bank 3</option>
                                       
                                        <option value="others">Others</option>
                                    </select>
                                </div>
                            </div>
                            <input type="hidden" id="productData" name="productData">
                            <div class="col-sm-5">
                                <hr>
                                <button type="submit" name="bill" class="btn btn-dark btn-sm">Generate Invoice</button>
                                <!--<button type="submit" name="hold" class="btn btn-success btn-sm">Hold Bill</button>-->
                                <button type="submit" name="refund" class="btn btn-danger btn-sm">Refund</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const generateInvoiceButton = document.querySelector("button[name='bill']");
    const refundButton = document.querySelector("button[name='refund']");

    generateInvoiceButton.addEventListener("click", function(event) {
        const method = document.getElementById("method").value;
        const customerName = document.getElementById("customer_name").value.trim();

        // Check if method is "credit" and customer name is empty
        if (method === "credit" && customerName === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please fill in the Customer Name for Credit method.");
        }
    });

    refundButton.addEventListener("click", function(event) {
        const refundId = document.getElementById("r_order_id").value.trim();

        // Check if Refund ID is empty when "Refund" button is clicked
        if (refundId === "") {
            event.preventDefault();  // Prevent form submission
            alert("Please enter a Refund ID.");
        }
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let currentFocus = -1;

   
    // Event listener for input field to trigger AJAX request
    document.getElementById("r_order_id").addEventListener("input", function() {
        var orderIdInput = this.value;
        if (orderIdInput.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?order_id=" + encodeURIComponent(orderIdInput), true); // Sends request to the same page
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("order_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("order_suggestions").style.display = 'none';
        }
    });

    // Handle clicking on suggestion items
    document.getElementById("order_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectOrder(e.target);
        }
    });

    // Add keyboard navigation for dropdown items
    document.getElementById("r_order_id").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("order_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectOrder(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectOrder(item) {
        var orderId = item.getAttribute('data-order-id');
        document.getElementById("r_order_id").value = orderId;
        document.getElementById("order_suggestions").style.display = 'none';
    }

    document.getElementById("customer_name").addEventListener("input", function() {
        var customerName = this.value;
        if (customerName.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?customer_name=" + customerName, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("customer_suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("customer_suggestions").style.display = 'none';
        }
    });

    document.getElementById("customer_suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectCustomer(e.target);
        }
    });

    document.getElementById("customer_name").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("customer_suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectCustomer(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectCustomer(item) {
        var customerName = item.getAttribute('data-customer-name');
        var customerId = item.getAttribute('data-customer-id');
        var customerPhone = item.getAttribute('data-customer-phone');

        document.getElementById("customer_name").value = customerName;
        document.getElementById("customer_phone").value = customerPhone;
        document.getElementById("customer_id").value = customerId;

        document.getElementById("customer_suggestions").style.display = 'none';
    }


function calculateTotalPrice() {
    let quantity = parseFloat(document.getElementById("quantity").value) || 0;
    let pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
    let discountPercent = parseFloat(document.getElementById("percentage").value) || 0;
    let extraAmount = parseFloat(document.getElementById("ex_percentage").value) || 0;

    let totalPrice = quantity * pricePerUnit;
    let discountAmount = (discountPercent / 100) * totalPrice;
    let finalPrice = totalPrice - discountAmount;

    // Convert extraAmount (in currency) to percentage of totalPrice
    if (totalPrice > 0 && extraAmount > 0) {
        let extraAsPercent = (extraAmount / totalPrice) * 100;
        finalPrice += (extraAsPercent / 100) * totalPrice;
    }

    if (finalPrice < 0) finalPrice = 0;

    document.getElementById("total_amount").value = totalPrice.toFixed(2);
    document.getElementById("trade_price").value = finalPrice.toFixed(2);
}

document.getElementById("quantity").addEventListener("input", calculateTotalPrice);
document.getElementById("retail_price").addEventListener("input", calculateTotalPrice);
document.getElementById("percentage").addEventListener("input", calculateTotalPrice);
document.getElementById("ex_percentage").addEventListener("input", calculateTotalPrice);


    document.getElementById("suggestions").addEventListener("click", function(e) {
        if (e.target && e.target.classList.contains("dropdown-item")) {
            selectProduct(e.target);
        }
    });

    document.getElementById("productInput").addEventListener("input", function() {
        var query = this.value;
        if (query.length > 0) {
            var xhr = new XMLHttpRequest();
            xhr.open("GET", "?query=" + query, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    var suggestions = document.getElementById("suggestions");
                    suggestions.innerHTML = xhr.responseText;
                    suggestions.style.display = 'block';
                }
            };
            xhr.send();
        } else {
            document.getElementById("suggestions").style.display = 'none';
        }
    });

    document.getElementById("productInput").addEventListener("keydown", function(e) {
        var suggestions = document.getElementById("suggestions");
        if (suggestions.style.display === 'block') {
            var items = suggestions.getElementsByClassName("dropdown-item");
            if (e.key === "ArrowDown") {
                currentFocus++;
                addActive(items);
            } else if (e.key === "ArrowUp") {
                currentFocus--;
                addActive(items);
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus > -1) {
                    if (items[currentFocus]) {
                        selectProduct(items[currentFocus]);
                    }
                }
            }
        }
    });

    function addActive(items) {
        if (!items) return false;
        removeActive(items);
        if (currentFocus >= items.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = items.length - 1;
        items[currentFocus].classList.add("active");
        items[currentFocus].scrollIntoView({ block: "nearest" });
    }

    function removeActive(items) {
        for (var i = 0; i < items.length; i++) {
            items[i].classList.remove("active");
        }
    }

    function selectProduct(item) {
        var selectedProduct = item.textContent;
        var retailPrice = item.getAttribute('data-retail-price');
        var productQuantity = item.getAttribute('data-product-quantity');
        var productRQuantity = item.getAttribute('data-product-Rquantity');
        var tradePrice = item.getAttribute('data-trade-price');
        var productId = item.getAttribute('data-product-id');
        var supplier = item.getAttribute('data-supplier');
        var company = item.getAttribute('data-company');
        var productUnit = item.getAttribute('data-product-unit');

        document.getElementById("productInput").value = selectedProduct;
        document.getElementById("retail_price").value = retailPrice;
        document.getElementById("re_quantity").value = productRQuantity;
        document.getElementById("productInput").setAttribute('data-product-id', productId);
        document.getElementById("productInput").setAttribute('data-product-quantity', productQuantity);
        document.getElementById("productInput").setAttribute('data-supplier', supplier);
        document.getElementById("productInput").setAttribute('data-company', company);
        document.getElementById("productInput").setAttribute('data-trade-price', tradePrice);
        document.getElementById("productInput").setAttribute('data-product-unit', productUnit);

        document.getElementById("suggestions").style.display = 'none';
        calculateTotalPrice();
    }

 document.getElementById("makeEntry").addEventListener("click", function() {
        var productInput = document.getElementById("productInput");
        var productId = productInput.getAttribute('data-product-id');
        var productQuantity = productInput.getAttribute('data-product-quantity'); // Parse the quantity and ensure it's a number
        var supplier = productInput.getAttribute('data-supplier');
        var company = productInput.getAttribute('data-company');

        var description = productInput.value;
        var quantity = parseFloat(document.getElementById("quantity").value) || 0;;
        var pricePerUnit = parseFloat(document.getElementById("retail_price").value) || 0;
        var totalPrice = parseFloat(document.getElementById("total_amount").value) || 0;
        var discountPercentage = parseFloat(document.getElementById("percentage").value) || 0;
        var netAmount = parseFloat(document.getElementById("trade_price").value) || 0;
        var tradePrice = productInput.getAttribute('data-trade-price');

        // Check if quantity is zero or negative before making the entry
        // if (quantity > productQuantity ) {
        //     alert("Sir NeuroCare Kindly Add Your Quantity in the Stock Please!!!!!!! .");
        //     return; // Stop execution if quantity is zero or negative
        // }

        if (productId && description && quantity && pricePerUnit && totalPrice && netAmount) {
            var table = document.getElementById("productsTable");
            var row = table.insertRow();
            row.innerHTML = `
                <td>${productQuantity}</td>
                <td style="font-weight:700;">${productId}</td>
                <td style="color:#0A5064;font-weight:700;">${description}</td>
                <td style="font-weight:700;">${quantity}</td>
                <td style="font-weight:700;">${pricePerUnit}</td>
                <td style="font-weight:700;">${totalPrice}</td>
                <td style="font-weight:700;">${discountPercentage || '0.00'}</td>
                <td>0</td>
                <td style="font-weight:700;">${netAmount}</td>
                <td style="display:none;">${supplier}</td>
                <td style="display:none;">${company}</td>
                <td style="display:none;">${tradePrice}</td>
                <td><button class="btn btn-danger btn-sm delete-row">X</button></td>
                <td><button class="btn btn-danger btn-sm edit-row">+</button></td>
            `;

            row.querySelector(".delete-row").addEventListener("click", function() {
                row.remove();
                calculateTotalAmount();
            });
            
            row.querySelector(".edit-row").addEventListener("click", function () {
            const cells = row.querySelectorAll("td");

            // Populate input fields
            productInput.value = cells[2].innerText;
            productInput.setAttribute('data-product-id', cells[1].innerText);
            productInput.setAttribute('data-supplier', cells[9].innerText);
            productInput.setAttribute('data-company', cells[10].innerText);
            productInput.setAttribute('data-trade-price', cells[11].innerText);

            document.getElementById("quantity").value = cells[3].innerText;
            document.getElementById("retail_price").value = cells[4].innerText;
            document.getElementById("total_amount").value = cells[5].innerText;
            document.getElementById("percentage").value = cells[6].innerText;
            document.getElementById("trade_price").value = cells[8].innerText;

            // Remove the row so user can re-submit it
            row.remove();
            calculateTotalAmount();

            productInput.focus();
        });
            
            calculateTotalAmount();

            var rows = document.querySelectorAll("#productsTable tr:not(:first-child)");
            var productData = [];
            rows.forEach(function(row) {
                var cells = row.querySelectorAll("td");
                var product = {
                    productId: cells[1].innerText,
                    description: cells[2].innerText,
                    quantity: cells[3].innerText,
                    pricePerUnit: cells[4].innerText,
                    totalPrice: cells[5].innerText,
                    discountPercentage: cells[6].innerText,
                    tax: cells[7].innerText,
                    netAmount: cells[8].innerText,
                    supplier: cells[9].innerText,
                    company: cells[10].innerText,
                    tradePrice: cells[11].innerText
                };
                productData.push(product);
            });

            document.getElementById("productData").value = JSON.stringify(productData);

            // Reset product fields after making an entry
            resetProductFields();
            
            // Automatically focus back to the productInput field
        productInput.focus();
        
        } else {
            alert("Some required fields are missing");
        }
    });

    function resetProductFields() {
        document.getElementById("productInput").value = '';
        document.getElementById("quantity").value = '';
        document.getElementById("retail_price").value = '';
        document.getElementById("total_amount").value = '';
        document.getElementById("percentage").value = '';
        document.getElementById("trade_price").value = '';
        // Remove data attributes for the next product
        document.getElementById("productInput").removeAttribute('data-product-id');
        document.getElementById("productInput").removeAttribute('data-product-quantity');
        document.getElementById("productInput").removeAttribute('data-supplier');
        document.getElementById("productInput").removeAttribute('data-company');
        document.getElementById("productInput").removeAttribute('data-trade-price');
        document.getElementById("productInput").removeAttribute('data-product-unit');
    }

    function calculateTotalAmount() {
        var table = document.getElementById("productsTable");
        var rows = table.getElementsByTagName("tr");
        var total = 0;

        for (var i = 1; i < rows.length; i++) {
            var netAmountCell = rows[i].cells[8];
            var netAmount = parseFloat(netAmountCell.textContent.trim());
            if (!isNaN(netAmount)) {
                total += netAmount;
            }
        }

        var totalInput = document.getElementById("total-input");
    var billAmountInput = document.getElementById("bill-amount");

    totalInput.value = total.toFixed(2);
    billAmountInput.value = total.toFixed(2);
        updateDiscountAmount();
    }

    function updateDiscountAmount() {
        var total = parseFloat(document.getElementById("total-input").value) || 0;
        var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
        var discountAmountInput = document.getElementById("discount_amount");
        var discountPercentInput = document.getElementById("discount_percent");

        if (!isNaN(billAmount) && !isNaN(total)) {
            var discountAmount = total - billAmount;
            discountAmountInput.value = Math.round(discountAmount);

            if (total > 0) {
                var discountPercent = (discountAmount / total) * 100;
                discountPercentInput.value = discountPercent.toFixed(2);
            } else {
                discountPercentInput.value = "0.00";
            }
        }
    }

    function calculateCashReturn() {
        var billAmount = parseFloat(document.getElementById("bill-amount").value) || 0;
        var cashReceived = parseFloat(document.getElementById("cash_received").value) || 0;
        var cashReturnInput = document.getElementById("cash_return");

        if (!isNaN(billAmount) && !isNaN(cashReceived)) {
            var cashReturn = cashReceived - billAmount;
            cashReturnInput.value = cashReturn.toFixed(2);
        }
    }

    document.getElementById("bill-amount").addEventListener("input", function() {
        updateDiscountAmount();
    });

    document.getElementById("cash_received").addEventListener("input", function() {
        calculateCashReturn();
    });

    calculateTotalAmount();
});
</script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</body>
</html>