<?php
include("../db/cn.php");
ob_start();

$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;
$totalDiscountAmount = 0;
$totalGrossAmount = 0;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
    }
}

$content = ob_get_clean();

function sendToPrinter($result) {
    $printerName = "EPSON_TM_T88V_Receipt";
    $handle = @fopen("USB", "w");
    if (!$handle) {
        echo "Error opening printer on Windows. Check the printer port and connection.";
        return;
    }
    fwrite($handle, $result);
    fclose($handle);
    echo "";
}

sendToPrinter($content);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <title>NEURO CARE</title>
    <style>
    body { font-family: 'Quicksand', sans-serif; }
    @media print {
        body { width: 66mm; margin: 0; padding: 0; }
        .container { width: 100%; margin: 0; padding: 0; }
        .no-print { display: none; }
        .text-center { text-align: center; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #000; padding: 5px; text-align: center; }
        .mb-0, .mb-1 { margin-bottom: 5px; }
    }
    </style>
</head>
<body>
<div class="container" id="invoice">
    <div class="text-center" style="margin-left:10px;">
        <h2 style="font-weight:600; text-transform:uppercase;">NEUROCARE</h2>
        <p class="mb-0" style="font-size:12px;margin-top:5px;text-transform:uppercase;font-weight:600;">
        ALAM SHER CENTER NISHTAR ROAD<br>MULTAN</p>
        <p class="mb-0" style="margin-top:-2px;font-weight:600;">03081222066</p>
    </div>

    <div>
        <p style="text-transform:capitalize;">
        <strong>Invoice#:</strong> <?php echo htmlspecialchars($orderId); ?><br>
        <strong>Date:</strong> <?php echo htmlspecialchars($dateTime." ".date('h:i:s')); ?><br></p>
    </div>

    <div>
        <table style="font-size: 9.5px;">
            <thead>
                <tr>
                    <th>Sr#</th>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                    <th>Dis%</th>
                    <th>Dis</th>
                    <th>PKR</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sr = 1;
                foreach ($orderDetails as $order): ?>
                <tr>
                    <td><?php echo $sr++; ?></td>
                    <td><?php echo htmlspecialchars($order['product_name']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
                    <td><?php echo htmlspecialchars($order['product_price']); ?></td>
                    <td>
                        <?php
                        $total = $order['product_price'] * $order['product_quantity'];
                        $totalGrossAmount += $total;
                        echo htmlspecialchars($total);
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars($order['discount']); ?></td>
                    <td>
                        <?php
                        $qty = $order['product_quantity'];
                        $price = $order['product_price'];
                        $discPer = $order['discount'];
                        $discAmt = ($price * $qty) * ($discPer / 100);
                        $totalDiscountAmount += $discAmt;
                        echo number_format($discAmt, 0);
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <?php
    $sub = mysqli_query($connection, "SELECT SUM(net_amount) AS sub FROM log_user_sales WHERE order_id = '$orderId'");
    $rowSub = mysqli_fetch_array($sub);

    $sql = "SELECT SUM(product_quantity) AS total_qty FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $sql);

    $totalQty = 0;
    if ($result && $row = mysqli_fetch_assoc($result)) {
        $totalQty = $row['total_qty'];
    }
    ?>
    <div>
        <strong>Total Qty :</strong>  <?php echo (int)$totalQty; ?> <br><br><br>
        <strong>Total :</strong> Rs <?php echo number_format($totalGrossAmount, 0); ?> /-<br>
        <strong>Dis :</strong> Rs <?php echo number_format($totalDiscountAmount, 0); ?> /-<br>
        <strong>Sub :</strong> Rs <?php echo number_format((float)$rowSub["sub"], 0); ?> /-<br>
        <strong>Bill_Dis :</strong> Rs <?php echo number_format($discounted, 0); ?> /-<br>
        <strong>Grand :</strong> Rs <?php echo number_format((float)$discountedAmount, 0); ?> /-<br>
        <!--<strong>Cash Recieved:</strong> Rs <?php echo number_format((float)$cashAmount, 0); ?> /-<br>-->
        <!--<strong>Cash Return:</strong> Rs <?php echo number_format((float)$changeAmount, 0); ?> /-<br>-->
    </div>

    <div>
        <h3>Notes:</h3>
        <p class="text-capitalize">1. ITEMS WILL BE RETURNED WITH CASH MEMO WITHIN 15 DAYS.<br>
        2. INHALERS/LOOSE TABLETS/LOTIONS/FRIDGE ITEMS/ COSMETICS ITEMS WILL NOT BE RETURNED.<br></p>
        <h3 style="text-align:center;">Thanks For Visiting.</h3>
    </div>

    <div class="text-center no-print">
        <button class="no-print" onclick="window.print()">Print</button>
        <button class="no-print" onclick="window.location.href='mainpos.php'">Exit</button>
    </div>
</div>
</body>
</html>
