<?php
include("db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["creditor"])) {
    $date_time32  = date("Y-m-d");
    $cr_name      = $_POST["cr_name"];
    $cr_address   = $_POST["cr_address"];
    $phone_number = $_POST["phone_number"];
    $cr_id        = $_POST["cr_id"];

    // updated query without cr_nickname
    $stmt = $connection->prepare("
        INSERT INTO credit_note 
        (cr_name, cr_address, phone_number, cr_id, user_name, user_role, outlet_name, outlet_address, date_time) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->bind_param(
        "sssssssss",
        $cr_name,
        $cr_address,
        $phone_number,
        $cr_id,
        $userName,
        $userRole,
        $outlet_name,
        $outlet_address,
        $date_time32
    );

    if ($stmt->execute()) {
        echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                icon: "success",
                title: "Customer added successfully!",
                showConfirmButton: false,
                timer: 2000
            }).then(function() {
                window.location.href = "view_creditor.php";
            });
        </script>';
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
}
ob_end_flush();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>Dewan Traders</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }
    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
	background:#0A4657;
	color:#fff;	
	}
.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	}  
.btn-primary:hover{
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }
    canvas {
      max-width: 100%;
      height: auto;
    }
	.fa-download:hover{
		color:#953E39;
		}
.text-primary{ 	
		}
  </style>

<body id="page-top">
    <div id="wrapper">
        <?php
        include("common/sd.php");
		?>
        <div id="content-wrapper" class="d-flex flex-column">

            <div id="content">
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

  <?php include('common/log.php');  ?>

                </nav>
 <div class="container">
        <div class="row">
            <br>
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Add Customer Ledger</h3>
                
            </div>
            <div class="col-sm-3">
               
            </div>
        </div>
        <div class="row">
          <div class="col-sm-2"></div>
          <div class="col-sm-8">
           
          </div>
          <div class="col-sm-2"></div>
        </div>
    </div><br />
   
    <div class="container">
        <form action="credits.php" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-sm-1"></div>
            <div class="col-sm-5">
                
                                <div class="form-group">
                                <label>Customer ID</label>
                                <input class="form-control mb-3" type="text"  name="cr_id" placeholder="" value="<?php
			  $pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
			   echo $pr_id2; ?>" readonly> 
                                </div>
                                <div class="form-group">
                                <label>Customer Name</label>
                                <input class="form-control mb-3" type="text"  name="cr_name" placeholder="" />
                                </div>
                                <div class="">
                                <input class="form-control mb-3" type="hidden"  name="cr_nickname"  />
                                </div>
                            
            </div>
            <div class="col-sm-5">
                <div class="form-group">
                                <label>Customer Address</label>
                                <input class="form-control mb-3" type="text"  name="cr_address" placeholder="" />
                                </div>
                                <div class="form-group">
                                <label>Phone Number</label>
                                 <input class="form-control mb-3" type="text"  name="phone_number"  />
                                </div>
                               
                                <button type="submit" class="btn btn-dark form-control" name="creditor" style="margin-top:30px;" > Enter</button>
            </div>
            <div class="col-sm-1">
            </div>
        </div>
          </form>
            </div>
            </div>
            <br><br>
            <?php include("common/main_ft.php");  ?>

        </div>
    </div>
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>

</body>
</html>