<?php
include("db/cn.php");
ob_start();
if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();

$transactions = [];
$totalBalance = 0;
$supplierName = '';
$startDate = '';
$endDate = '';

if (isset($_POST['filter'])) {
    $supplierName = $_POST['supplier'];
    $startDate = $_POST['startDate'];
    $endDate = $_POST['endDate'];

    // Helper function to validate and format dates
    function isValidDate($dateString) {
        // Check for '0000-00-00' or '00-00-0000' or similar invalid dates
        if (empty($dateString) || $dateString == '0000-00-00 00:00:00' || $dateString == '0000-00-00' || $dateString == '00-00-0000') {
            return false;
        }

        // Check if the date can be converted to a valid timestamp
        $timestamp = strtotime($dateString);
        if ($timestamp === false || $timestamp == strtotime('01-01-1970')) {
            return false;
        }

        return true;
    }

    // Helper function to format the date for display
    function formatDateForDisplay($dateString) {
        if (isValidDate($dateString)) {
            return date("d-m-Y", strtotime($dateString)); // Change display format here
        }
        return ''; // Return empty string if date is invalid
    }

    // Get supplier opening balance (within the date range)
    $query = "SELECT open_amount AS amount, date_time 
              FROM supplier_opening_amount 
              WHERE supplier_name = '$supplierName' 
              AND date_time BETWEEN '$startDate' AND '$endDate'";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $openingBalance = $row['amount'];
        $date_time = $row['date_time'];

        // Check for valid date before processing
        if (isValidDate($date_time)) {
            $totalBalance += $openingBalance;
            $transactions[] = [
                'date' => formatDateForDisplay($date_time),
                'description' => 'Opening Balance',
                'amount' => $openingBalance,
                'type' => 'balance'
            ];
        }
    }

    // Get cash-like purchases (do not affect total balance)
    $query = "SELECT discount_amount AS amount, date_time, paid_by 
              FROM purchase 
              WHERE customer_name = '$supplierName' AND paid_by = 'Credit' 
              AND date_time BETWEEN '$startDate' AND '$endDate'
              GROUP BY inv_id";
    $result = mysqli_query($connection, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $date_time = $row['date_time'];

        // Check for valid date before processing
        if (isValidDate($date_time)) {
            $transactions[] = [
                'date' => formatDateForDisplay($date_time),
                'description' => $row['paid_by'] . ' Purchase',
                'amount' => $row['amount'],
                'type' => 'no_effect'
            ];
        }
    }

    // Get credit purchases (affect total balance as debit)
    $query = "SELECT discount_amount AS amount, date_time 
              FROM purchase 
              WHERE customer_name = '$supplierName' AND paid_by = 'Credit' 
              AND status = '' AND r_inv_id = '' AND date_time BETWEEN '$startDate' AND '$endDate'
              GROUP BY inv_id";
    $result = mysqli_query($connection, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $date_time = $row['date_time'];

        // Check for valid date before processing
        if (isValidDate($date_time)) {
            $transactions[] = [
                'date' => formatDateForDisplay($date_time),
                'description' => 'Credit Purchase',
                'amount' => -$row['amount'],
                'type' => 'debit'
            ];
            $totalBalance += $row['amount'];
        }
    }

    // Get payments made to supplier (affect total balance as credit)
    $query = "SELECT supplier_amount AS amount, date_time 
              FROM supplier_paid 
              WHERE supplier_name = '$supplierName' 
              AND date_time BETWEEN '$startDate' AND '$endDate'";
    $result = mysqli_query($connection, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $date_time = $row['date_time'];

        // Check for valid date before processing
        if (isValidDate($date_time)) {
            $transactions[] = [
                'date' => formatDateForDisplay($date_time),
                'description' => 'Payment to Supplier',
                'amount' => $row['amount'],
                'type' => 'credit'
            ];
            $totalBalance -= $row['amount'];
        }
    }

    // Get purchase returns (affect total balance as credit only if 'paid_by' is 'Credit')
    $query = "SELECT discount_amount AS amount, date_time 
              FROM purchase 
              WHERE customer_name = '$supplierName' AND paid_by = 'Credit'  
              AND status = 'return' AND date_time BETWEEN '$startDate' AND '$endDate'
              GROUP BY r_inv_id";
    $result = mysqli_query($connection, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $date_time = $row['date_time'];

        // Check for valid date before processing
        if (isValidDate($date_time)) {
            $transactions[] = [
                'date' => formatDateForDisplay($date_time),
                'description' => 'Purchase Return',
                'amount' => -$row['amount'],
                'type' => 'credit'
            ];
            $totalBalance -= $row['amount'];
        }
    }

    // Sort transactions by date
    usort($transactions, function($a, $b) {
        return strtotime($a['date_time']) - strtotime($b['date_time']);
    });
}
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Dewan Traders</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
 #table-container-wrapper {
    max-height: 460px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.btn, .form-control, tr{
	  	font-weight:700;
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <?php
                	$supplierQuery = "SELECT DISTINCT supplier_name FROM supplier";
                                $supplierResult = mysqli_query($connection, $supplierQuery);
                ?>
                      <div class="container-fluid mt-5">
            <div class="row">
        <div class="col-sm-3">
     <h3 style="font-weight:700; color:#060606;">Supplier Report</h3>
        </div>
        <div class="col-sm-6"></div>
        <div class="col-sm-3">
             
        </div>
    </div>
       <br>
            <form method="post">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="supplier">Supplier Name:</label>
                            <select class="form-control" name="supplier" required style="text-transform:capitalize;">
                                <option value="">Select Supplier</option>
                                <!-- Populate suppliers from the database -->
                                <?php
                                
                                while ($supplierRow = mysqli_fetch_assoc($supplierResult)) {
         echo '<option value="' . $supplierRow['supplier_name'] . '">' . $supplierRow['supplier_name'] . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="startDate">Start Date:</label>
                            <input type="date" class="form-control" name="startDate" value="<?php echo $startDate; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="endDate">End Date:</label>
                            <input type="date" class="form-control" name="endDate" value="<?php echo $endDate; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                    <div class="form-group">
                        
                        <button type="submit" class="btn btn-dark" name="filter" style="margin-top:30px;">Filter</button>
                         <a href="report_supplier.php"><button type="button" class="btn btn-dark"  style="margin-top:30px;"><i class="fas fa-sync-alt fa-1x"></i></button></a>
<button id="downloadExcel" type='button' class="btn btn-dark " style="margin-top:30px;">Download </button>
<button id="downloadPdf" type='button' class="btn btn-danger " style="margin-top:30px;"><i class="fas fa-file fa-1x"></i> Download Pdf</button>


                    </div>
                </div>
                </div>
                
                <div id='report'>
                       <?php if (!empty($transactions)) : ?>
                    <h3 style="background:#0A4657; color:#fff;padding:20px; border-radius:10px;text-align:center;
                    text-transform:capitalize;">Supplier Ledger Report : <?php echo $supplierName; ?></h3>

                    <div class="row">
                       <div class="col-sm-12" id="table-container-wrapper">
    <table id="patientTable" class="table table-striped table-hover text-center table-sm bg-white"  >
        <thead>
            <tr class="bg-dark text-white">
                <th>Date</th>
                <th>Description</th>
                <th>Debit Amount (Rs)</th>
                <th>Credit Amount (Rs)</th>
                <th>Balance (Rs)</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        // Set initial balance from the opening balance
        $runningBalance = $openingBalance; 
        ?>
        <tr>
            <td style="color:#0A4657; font-weight:700;"><?php echo date('d-m-Y', strtotime($openingBalanceDate)); ?></td>
            <td style="color:#0A4657; font-weight:700;">Opening Balance</td>
            
            <td></td>
            <td style="color:#0A4657; font-weight:700;"><?php echo number_format($openingBalance, 2); ?></td>
            <td style="color:#0A4657; font-weight:700;"><?php echo number_format($runningBalance, 2); ?></td>
        </tr>
        <?php 
        // Iterate over each transaction to update the running balance
        foreach ($transactions as $transaction) : 
            $positiveAmount = '';
            $negativeAmount = '';

            // Determine positive and negative amounts
            if ($transaction['type'] == 'debit') {
                $runningBalance += abs($transaction['amount']);
                $positiveAmount = number_format(abs($transaction['amount']), 2);
            } elseif ($transaction['type'] == 'credit') {
                $runningBalance -= abs($transaction['amount']);
                $negativeAmount = number_format(abs($transaction['amount']), 2);
            }
        ?>
            <tr style="color:#060606;">
                <td><?php echo date('d-m-Y', strtotime($transaction['date'])); ?></td>
                <td style="text-transform:capitalize;"><?php echo $transaction['description']; ?></td>
                <td><?php echo $negativeAmount; ?></td>
                <td><?php echo $positiveAmount; ?></td>
                
                <td><?php echo number_format($runningBalance, 2); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>


                        <div class="col-sm-12">
                            <table class="table bg-white" style="color:#060606;">
                                <tfoot>
                                    <tr>
                                        <th>Final Balance:</th>
                                        <td><?php echo number_format($totalBalance, 2); ?></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                <?php else : ?>
                    <?php if (isset($_POST['filter'])) : ?>
                        <div class="alert alert-warning">
                            No records found for the selected supplier and date range.
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </form>
        </div>


    
            
                <!-- /.container-fluid -->

            </div>
                </div>
             

            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

      <!-- Include the SheetJS (xlsx) library -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Patients" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Supplier_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
    
    
    document.getElementById("downloadPdf").addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const report = document.getElementById("report");

    // Get current date & time
    const now = new Date();
    const formattedDateTime = now.toLocaleDateString() + " " + now.toLocaleTimeString();

    html2canvas(report, { scale: 2 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF("p", "mm", "a4");
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

        // Add report image shifted down for header
        pdf.addImage(imgData, "PNG", 0, 30, pdfWidth, pdfHeight);

        // === Header text ===
        pdf.setFont("helvetica", "bold");
        pdf.setFontSize(14);
        pdf.text("Supplier Report", pdfWidth / 2, 12, { align: "center" });

        // Optional: Add print timestamp
        pdf.setFontSize(10);
        pdf.setFont("helvetica", "normal");
        pdf.text(`Printed: ${formattedDateTime}`, pdfWidth - 10, 20, { align: "right" });

        pdf.save("Supplier-Report.pdf");
    });
});
</script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>