<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include("../db/cn.php");
ob_start();

// Check session
if (isset($_SESSION['user_name'], $_SESSION['user_role'], $_SESSION['outlet_name'], $_SESSION['outlet_address'])) {
    $userName       = $_SESSION['user_name'];
    $userRole       = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name    = $_SESSION['outlet_name'];
} else {
    echo "Session variables not set. Please log in.";
    exit;
}

$alertScript = ""; // JS script ko variable me store karenge

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize input
    $product_id     = mysqli_real_escape_string($connection, $_POST['product_id']);
    $product_code   = mysqli_real_escape_string($connection, $_POST['product_code']);
    $product_name   = mysqli_real_escape_string($connection, $_POST['product_name']);
    $company        = mysqli_real_escape_string($connection, $_POST['company']);
    $quantity       = (int)$_POST['quantity'];
    $retail_price   = (float)$_POST['retail_price'];
    $percentage     = (float)$_POST['percentage'];
    $trade_price    = (float)$_POST['trade_price'];
    $total_amount   = (float)$_POST['total_amount'];
    $supplier       = mysqli_real_escape_string($connection, $_POST['supplier']);
    $product_unit   = mysqli_real_escape_string($connection, $_POST['product_unit']);
    $category       = mysqli_real_escape_string($connection, $_POST['category']);
    $model       = mysqli_real_escape_string($connection, $_POST['model']);
    $maker       = mysqli_real_escape_string($connection, $_POST['maker']);
    $total_purchase = $trade_price * $quantity;
    $date_time      = date("Y-m-d");

$uploaded_file_path = '';
if (isset($_FILES['img_upload']) && $_FILES['img_upload']['error'] === UPLOAD_ERR_OK) {
    $fileTmp  = $_FILES['img_upload']['tmp_name'];
    $fileName = time() . "_" . basename($_FILES['img_upload']['name']); // unique name
    $fileType = mime_content_type($fileTmp);

    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
    if (!in_array($fileType, $allowedTypes)) {
        die("Invalid file type. Only JPG, PNG, GIF allowed.");
    }

    $uploadDir = __DIR__ . '/uploads/';  // absolute path
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $targetFile = $uploadDir . $fileName;

    if (move_uploaded_file($fileTmp, $targetFile)) {
        $uploaded_file_path = 'uploads/' . $fileName; // relative path for DB
    } else {
        echo "Error moving uploaded file.";
    }
}
    // Check duplicate
    $check_query  = "SELECT * FROM products WHERE product_id = '$product_id'";
    $check_result = mysqli_query($connection, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // Duplicate product
        $alertScript = "
            Swal.fire({
                icon: 'warning',
                title: 'Duplicate Entry',
                text: 'Product ID: $product_id and Product Name: $product_name already exist!'
            });
        ";
    } else {
        // Insert into products
        $insert_product_query = "INSERT INTO products 
            (product_id, product_code, product_name, category, company, model, maker, quantity, retail_price, percentage, trade_price, total_amount, total_purchase, product_unit, supplier, date_time, login_user, user_role, outlet_name, outlet_address, img_upload) 
            VALUES 
            ('$product_id', '$product_code', '$product_name', '$category', '$company', '$model', '$maker', '$quantity', '$retail_price', '$percentage', '$trade_price', '$total_amount', '$total_purchase', '$product_unit', '$supplier', '$date_time', '$userName', '$userRole', '$outlet_name', '$outlet_address', '$uploaded_file_path')";

        if (!mysqli_query($connection, $insert_product_query)) {
            $alertScript = "
                Swal.fire({
                    icon: 'error',
                    title: 'Error inserting product',
                    text: '" . addslashes(mysqli_error($connection)) . "'
                });
            ";
        } else {
            // Insert into opening_products
            $insert_opening_product_query = "INSERT INTO opening_products 
                (product_id, product_name, category, company, quantity, retail_price, percentage, trade_price, total_amount, product_unit, supplier, date_time, login_user, user_role, outlet_name, outlet_address) 
                VALUES 
                ('$product_id', '$product_name', '$category', '$company', '$quantity', '$retail_price', '$percentage', '$trade_price', '$total_amount', '$product_unit', '$supplier', '$date_time', '$userName', '$userRole', '$outlet_name', '$outlet_address')";

            if (!mysqli_query($connection, $insert_opening_product_query)) {
                $alertScript = "
                    Swal.fire({
                        icon: 'error',
                        title: 'Error inserting opening product',
                        text: '" . addslashes(mysqli_error($connection)) . "'
                    });
                ";
            } else {
                // Success popup
                $alertScript = "
                    Swal.fire({
                        icon: 'success',
                        title: 'Product saved successfully!',
                        showConfirmButton: false,
                        timer: 2000
                    }).then(() => {
                        window.location.href = 'addproduct.php';
                    });
                ";
            }
        }
    }
}
$pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
$barcodeUrl = "https://barcode.tec-it.com/barcode.ashx?data={$pr_id2}&code=Code128&dpi=96";
$barcodeFilename = "barcode_$pr_id2.png";
ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Ali Zain Autos</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.text-primary{
	  	
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  
    $c = mysqli_query($connection,"select * from category");
    $m = mysqli_query($connection,"select * from model_no");
    $ma = mysqli_query($connection,"select * from maker");
    $com = mysqli_query($connection,"select * from company");
    ?>
                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
 <div class="container">
        <div class="row">
            <div class="col-sm-9">
                <h3 style="color:#212529; font-weight:700;"> Add Opening Stock</h3>
                
            </div>
            <div class="col-sm-3">
               
            </div>
        </div>
        <div class="row">
          <div class="col-sm-2"></div>
          <div class="col-sm-8">
           
          </div>
          <div class="col-sm-2"></div>
        </div>
    </div><br />
    <br />
    <br />
  <div class="container">
        <div class="row">
                <div class="col-sm-1"></div>
                <div class="col-sm-5">
                    <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
                        <div class="form-group">
                            <label>Product ID</label>
                            <input type="text" name="product_id" class="form-control" value="<?php
                                $pr_id2 = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
                                echo $pr_id2;
                            ?>" readonly> 
                        </div>
                        <div class="form-group">
                            <label>Part No.</label>
                            <input type="text" name="product_code" class="form-control" required />
                        </div>
                        <div class="form-group">
                            <label>Product Name</label>
                            <input type="text" name="product_name" class="form-control" required />
                        </div>
                        <div class="row">
                        <div class="form-group col-6">
                            <label>Category</label>
                            <select name="category" class="form-control" >
                            <option value="">Select</option>
                            <?php
                             while($cc = mysqli_fetch_array($c)){
                            ?>
                            <option value="<?php echo $cc['category_no']; ?>"><?php echo $cc['category_no']; ?></option>
                            <?php
                             }
                            ?>
                            </select>    
                        </div>
                        <div class="form-group col-6">
                            <label>Company</label>
                            <select name="company" class="form-control" >
                             <option value="">Select</option>
                            <?php
                             while($coc = mysqli_fetch_array($com)){
                            ?>
                            <option value="<?php echo $coc['company_no']; ?>"><?php echo $coc['company_no']; ?></option>
                            <?php
                             }
                            ?>
                            </select> 
                        </div>
                        </div>
                        <div class="row">
                        <div class="form-group col-6">
                            <label>Model</label>
                            <select name="model" class="form-control" >
                                 <option value="">Select</option>
                            <?php
                             while($cm = mysqli_fetch_array($m)){
                            ?>
                            <option value="<?php echo $cm['model']; ?>"><?php echo $cm['model']; ?></option>
                            <?php
                             }
                            ?>
                            </select> 
                        </div>
                        <div class="form-group col-6">
                                <label>Maker</label>
                                <select name="maker" class="form-control" >
                                <option value="">Select</option>
                            <?php
                             while($cma = mysqli_fetch_array($ma)){
                            ?>
                            <option value="<?php echo $cma['maker_no']; ?>"><?php echo $cma['maker_no']; ?></option>
                            <?php
                             }
                            ?>
                            </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Quantity</label>
                            <input type="number" name="quantity" id="quantity" class="form-control" />
                        </div>
                        <div class="form-group">
                            <label>Sale Price</label>
                            <input type="number" name="retail_price" id="retail_price" class="form-control" />
                        </div>
                </div>
            
                <div class="col-sm-5">
                    <div class="form-group">
                        <label>% Apply</label>
                        <input type="text" name="percentage" id="percentage" class="form-control" readonly />
                    </div>
                    <div class="form-group">
                        <label>Purchase Price</label>
                        <input type="number" name="trade_price" id="trade_price" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Total Amount</label>
                        <input type="number" name="total_amount" id="total_amount" class="form-control" readonly />
                    </div>
                    <div class="form-group">
                        <label>Supplier</label>
                        <input type="text" name="supplier" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Product Unit</label>
                        <select name="product_unit" class="form-control">
                            <option value="">Select Unit</option>
                            <option value="Pcs">Pcs</option>
                        </select>
                    </div>
                    <div class="form-group">
                     <label>Image</label>
                     <input type="file" name="img_upload" class="form-control btn-primary text-white"  >
                        <input type="hidden" name="expiry_d" value="0"  class="form-control">
                    </div>
                    <hr />
                    <button class="btn btn-dark form-control" type="submit">Save Product</button>
                </div>
            </div>
           
    </div>
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            <?php if (!empty($alertScript)) { echo $alertScript; } ?>
        });
    </script>
<script>
    function calculateTotalAmount() {
        let quantity = parseFloat(document.querySelector('input[name="quantity"]').value) || 0;
        let trade_price = parseFloat(document.getElementById("trade_price").value) || 0;

        if (quantity > 0 && trade_price > 0) {
            let total_amount = (quantity * trade_price).toFixed(2);
            document.getElementById("total_amount").value = total_amount;
        } else {
            document.getElementById("total_amount").value = '';
        }
    }

    function calculateTradePercentage() {
        let retail_price = parseFloat(document.getElementById("retail_price").value) || 0;
        let trade_price = parseFloat(document.getElementById("trade_price").value) || 0;

        if (retail_price > 0 && trade_price > 0) {
            let percentage = ((retail_price - trade_price) * 100 / retail_price).toFixed(2);
            document.getElementById("percentage").value = percentage;
        } else {
            document.getElementById("percentage").value = '';
        }
    }

    document.addEventListener('DOMContentLoaded', (event) => {
        document.querySelector('input[name="quantity"]').addEventListener('input', calculateTotalAmount);
        document.getElementById("retail_price").addEventListener('input', calculateTradePercentage);
        document.getElementById("trade_price").addEventListener('input', () => {
            calculateTradePercentage();
            calculateTotalAmount();
        });
    });

    document.addEventListener("DOMContentLoaded", function () {
        var sidebar = document.getElementById("sidebar");
        var overlay = document.createElement("div");
        overlay.classList.add("overlay");
        document.body.appendChild(overlay);

        function toggleSidebar() {
            sidebar.classList.toggle("hide");
            overlay.classList.toggle("hide");

            var mainContent = document.querySelector(".main-content");
            if (sidebar.classList.contains("hide")) {
                mainContent.style.marginLeft = "0";
            } else {
                mainContent.style.marginLeft = "100px"; // Width of the sidebar
            }
        }

        overlay.addEventListener("click", function () {
            toggleSidebar();
        });

        var navbarToggler = document.querySelector(".navbar-toggler");
        navbarToggler.addEventListener("click", function () {
            toggleSidebar();
        });

        function checkScreenSize() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove("hide");
                overlay.classList.remove("hide");
            } else {
                sidebar.classList.add("hide");
                overlay.classList.add("hide");
            }
        }

        checkScreenSize();
        window.addEventListener("resize", checkScreenSize);
    });

    function toggleSubMenu(element) {
        $(element).next('.sub-menu').slideToggle();
    }
</script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>