<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (!isset($_GET['inv_id'])) {
    die("Order ID not provided.");
}

$orderId = $_GET['inv_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantities = $_POST['quantities'];
    $prices = $_POST['prices'];
    $discounts = $_POST['discounts'];

    $grandTotal = 0;

    foreach ($quantities as $id => $qty) {
        $price = $prices[$id];
        $discount = $discounts[$id];

        // Calculate net_amount per item
        $netAmount = ((int)$price * (int)$qty) - (int)$discount;
        $grandTotal += $netAmount;

        $updateItem = "UPDATE purchase 
            SET product_quantity = '$qty', 
                product_price = '$price', 
                discount = '$discount',
                net_amount = '$netAmount'
            WHERE inv_id = '$orderId' AND id = '$id'";

        if (!mysqli_query($connection, $updateItem)) {
            die("Update failed: " . mysqli_error($connection));
        }
    }

    // Update discount_amount in all rows (optional: normalize by storing in order table)
    $updateDiscountAmount = "UPDATE purchase
        SET discount_amount = '$grandTotal'
        WHERE inv_id = '$orderId'";

    if (!mysqli_query($connection, $updateDiscountAmount)) {
        die("Failed to update discount_amount: " . mysqli_error($connection));
    }

    echo "<script>alert('Invoice updated successfully!'); window.location.href='purchase_detail_v.php';</script>";
    exit();
}

// Fetch order details
$result = mysqli_query($connection, "SELECT * FROM purchase WHERE inv_id = '$orderId'");
if (mysqli_num_rows($result) == 0) {
    die("Order not found.");
}
$orderRows = [];
while ($row = mysqli_fetch_assoc($result)) {
    $orderRows[] = $row;
}
ob_end_flush();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Ali Zain Autos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
    <h3>Edit Invoice: <?php echo htmlspecialchars($orderId); ?></h3>
    <form method="POST" id="editForm">
        <table class="table text-center table-sm" style="font-size:14px;">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Price(Rs)</th>
                    <th>Discount(Rs)</th>
                    <th>Total(Rs)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orderRows as $row): ?>
                    <tr>
                        <td><?php echo $row['product_name']; ?></td>
                        <td>
                            <input type="number" name="quantities[<?php echo $row['id']; ?>]" class="form-control qty" value="<?php echo $row['product_quantity']; ?>" min="1">
                        </td>
                        <td>
                            <input type="number" name="prices[<?php echo $row['id']; ?>]" class="form-control price" value="<?php echo $row['product_price']; ?>" step="0.01">
                        </td>
                        <td>
                            <input type="number" name="discounts[<?php echo $row['id']; ?>]" class="form-control discount" value="<?php echo $row['discount']; ?>" step="0.01">
                        </td>
                        <td class="total">0</td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="text-end">
            <p><strong>Sub:</strong> Rs <span id="subtotal">0</span></p>
            <p><strong>Total:</strong> Rs <span id="grandtotal">0</span></p>
        </div>

        <button type="submit" class="btn btn-success">Update Order</button>
        <a href="order_detail_v.php" class="btn btn-secondary">Cancel</a>
    </form>

    <script>
        function calculateTotals() {
            let subtotal = 0;
            document.querySelectorAll('tbody tr').forEach(function(row) {
                const qty = parseFloat(row.querySelector('.qty').value) || 0;
                const price = parseFloat(row.querySelector('.price').value) || 0;
                const discount = parseFloat(row.querySelector('.discount').value) || 0;
                const total = (qty * price) - discount;
                row.querySelector('.total').innerText = total.toFixed(2);
                subtotal += total;
            });
            document.getElementById('subtotal').innerText = subtotal.toFixed(2);
            document.getElementById('grandtotal').innerText = subtotal.toFixed(2);
        }

        document.querySelectorAll('.qty, .price, .discount').forEach(el => {
            el.addEventListener('input', calculateTotals);
        });

        window.addEventListener('DOMContentLoaded', calculateTotals);
    </script>
</body>
</html>
