<?php
include("../db/cn.php");
session_start();


if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

// Get the ID from URL
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch the record to edit
$record = null;
if ($id > 0) {
    $query = "SELECT * FROM credit_paid WHERE id = $id";
    $result = mysqli_query($connection, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $record = mysqli_fetch_assoc($result);
    } else {
        header("Location: credit_rec.php");
        exit();
    }
} else {
    header("Location: credit_rec.php");
    exit();
}

// Handle form submission for update
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["update_credit"])) {
    $date_time = $_POST["date_time"] ?? date("Y-m-d");
    $cr_name = mysqli_real_escape_string($connection, $_POST["cr_name"]);
    $amount = floatval($_POST["amount"]);
    $paid_by = mysqli_real_escape_string($connection, $_POST["paid_by"]);
    $description = mysqli_real_escape_string($connection, $_POST["desc"]);
    
    $updateQuery = "
        UPDATE credit_paid 
        SET cr_name = '$cr_name', 
            amount = '$amount', 
            paid_by = '$paid_by', 
            description = '$description', 
            date_time = '$date_time',
            user_name = '$userName',
            user_role = '$userRole',
            outlet_name = '$outlet_name',
            outlet_address = '$outlet_address'
        WHERE id = $id
    ";

    if (mysqli_query($connection, $updateQuery)) {
        echo "<script>alert('Record updated successfully!'); window.location.href='credit_rec.php';</script>";
    } else {
        echo "<script>alert('Error updating record: " . mysqli_error($connection) . "');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Edit Received Amount</title>

    <!-- Fonts & CSS -->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300;500;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">

    <style>
        body { font-family: 'Quicksand', sans-serif; }
        .bg-gradient-primary { background: #0A4657; color: #fff; }
        .btn-primary { background: #0A4657; border: 1px solid #0A4657; }
        .btn-primary:hover { background: #fff; color: #0A4657; }
        .card { border-radius: 12px; }
        .card-header { background: #0A4657; color: white; }
        .form-control, .btn, option{font-weight:700; text-transform:capitalize;}
        .back-btn { margin-bottom: 20px; }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <!-- Sidebar -->
        <?php include("common/sd.php"); ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>
                    <?php include('common/log.php'); ?>
                </nav>
                <!-- End of Topbar -->

                <!-- Page Content -->
                <div class="container-fluid mt-3">
                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <!-- Back Button -->
                            <a href="credit_rec.php" class="btn btn-secondary back-btn">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                            
                            <div class="card shadow">
                                <div class="card-header">
                                    <h5 class="mb-0 font-weight-bold">Edit Received Amount</h5>
                                </div>
                                <div class="card-body">
                                    <form method="post" action="edit_credit_rec.php?id=<?= $id; ?>" enctype="multipart/form-data">
                                        <!-- Customer Select -->
                                      <!-- Customer Name (Plain Text) -->
<div class="form-group mb-3">
    <label class="font-weight-bold">Customer Name</label>
    <div class="form-control-plaintext border rounded p-2 bg-light">
        <strong><?= htmlspecialchars($record['cr_name']); ?></strong>
    </div>
    <input type="hidden" name="cr_name" value="<?= htmlspecialchars($record['cr_name']); ?>">
</div>

                                        <!-- Amount -->
                                        <div class="form-group mb-3">
                                            <label class="font-weight-bold">Amount</label>
                                            <input type="number" name="amount" placeholder="Enter Amount" 
                                                   class="form-control" required 
                                                   value="<?= htmlspecialchars($record['amount']); ?>">
                                        </div>

                                        <!-- Payment Method -->
                                        <div class="form-group mb-3">
                                            <label class="font-weight-bold">Payment Method</label>
                                            <select name="paid_by" class="form-control" required>
                                                <option value="">-- Select Method --</option>
                                                <?php
                                                $methods = ['cash', 'bank1', 'bank2', 'bank3', 'other'];
                                                foreach ($methods as $method) {
                                                    $selected = ($record['paid_by'] == $method) ? 'selected' : '';
                                                    echo '<option value="' . $method . '" ' . $selected . '>' . 
                                                         ucfirst($method) . '</option>';
                                                }
                                                ?>
                                            </select>
                                        </div>

                                        <!-- Description -->
                                        <div class="form-group mb-3">
                                            <label class="font-weight-bold">Description</label>
                                            <textarea name="desc" class="form-control" placeholder="Enter description..." rows="3"><?= htmlspecialchars($record['description']); ?></textarea>
                                        </div>

                                        <!-- Date -->
                                        <div class="form-group mb-3">
                                            <label class="font-weight-bold">Date</label>
                                            <input class="form-control" type="date" name="date_time" required 
                                                   value="<?= htmlspecialchars($record['date_time']); ?>">
                                        </div>

                                        <!-- Original User Info (Readonly) -->
                                        <div class="form-group mb-3">
                                            <label class="font-weight-bold">Original Entered By</label>
                                            <input type="text" class="form-control" readonly 
                                                   value="<?= htmlspecialchars($record['user_name'] . ' (' . $record['date_time'] . ')'); ?>">
                                            <small class="text-muted">This record was originally created by <?= htmlspecialchars($record['user_name']); ?></small>
                                        </div>

                                        <!-- Submit Buttons -->
                                        <div class="d-flex justify-content-between">
                                            <a href="credit_rec.php" class="btn btn-secondary">
                                                <i class="fas fa-times"></i> Cancel
                                            </a>
                                            <button type="submit" name="update_credit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> Update Record
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>

            <!-- Footer -->
            <?php include("common/main_ft.php"); ?>
        </div>
    </div>

    <!-- Scroll to Top -->
    <a class="scroll-to-top rounded" href="#page-top"><i class="fas fa-angle-up"></i></a>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    

</body>
</html>