<?php
include('db/cn.php');
include('common/tx.php');

// ==========================
// Get cr_id from URL
// ==========================
$cr_id = $_GET['cr_id'] ?? null;
if (!$cr_id) {
    die("Invalid Credit Note ID");
}

// ==========================
// Update Record
// ==========================
if (isset($_POST['update'])) {
    $cr_name      = $_POST['cr_name'];
    $cr_nickname  = $_POST['cr_nickname'];
    $cr_address   = $_POST['cr_address'];
    $phone_number = $_POST['phone_number'];
    $date_time    = $_POST['date_time'];
    $open_amount  = $_POST['open_amount']; // New input from form

    // --------------------------
    // Update credit_note table
    // --------------------------
    $update = $connection->prepare("
        UPDATE credit_note SET
            cr_name = ?,
            cr_nickname = ?,
            cr_address = ?,
            phone_number = ?,
            date_time = ?
        WHERE cr_id = ?
    ");

    $update->bind_param(
        "sssssi",
        $cr_name,
        $cr_nickname,
        $cr_address,
        $phone_number,
        $date_time,
        $cr_id
    );

    if ($update->execute()) {
        $success = "Credit Note Updated Successfully";
    } else {
        $error = "Update Failed";
    }

    // --------------------------
    // Update creditor_opening_amount table
    // --------------------------
    $update_open = $connection->prepare("
        UPDATE creditor_opening_amount SET
            open_amount = ?
        WHERE creditor_name = ?
    ");
    $update_open->bind_param("ds", $open_amount, $cr_name); // "d" for double (decimal)
    $update_open->execute();
}

// ==========================
// Fetch Existing Record + open_amount from creditor_opening_amount table
// ==========================
$select = $connection->prepare("
    SELECT 
        cn.*,
        coa.open_amount
    FROM credit_note cn
    LEFT JOIN creditor_opening_amount coa
        ON coa.creditor_name = cn.cr_name
    WHERE cn.cr_id = ?
");
$select->bind_param("i", $cr_id);
$select->execute();
$data = $select->get_result()->fetch_assoc();

if (!$data) {
    die("Record Not Found");
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Credit Note</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <h3>Edit Credit Note</h3>

    <?php if (!empty($success)) : ?>
        <div class="alert alert-success"><?= $success ?></div>
    <?php endif; ?>

    <?php if (!empty($error)) : ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">

        <div class="mb-3">
            <label class="form-label">Customer Name</label>
            <input type="text" name="cr_name" class="form-control"
                   value="<?= htmlspecialchars($data['cr_name']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Nick Name</label>
            <input type="text" name="cr_nickname" class="form-control"
                   value="<?= htmlspecialchars($data['cr_nickname']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Address</label>
            <input type="text" name="cr_address" class="form-control"
                   value="<?= htmlspecialchars($data['cr_address']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Phone Number</label>
            <input type="text" name="phone_number" class="form-control"
                   value="<?= htmlspecialchars($data['phone_number']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Date & Time</label>
            <input type="datetime-local" name="date_time" class="form-control"
                   value="<?= date('Y-m-d\TH:i', strtotime($data['date_time'])) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Opening Amount</label>
            <input type="number" step="0.01" name="open_amount" class="form-control"
                   value="<?= htmlspecialchars($data['open_amount'] ?? '0') ?>" required>
        </div>

        <button type="submit" name="update" class="btn btn-primary">
            Update Record
        </button>

        <a href="view_creditor.php" class="btn btn-secondary">
            Back
        </a>

    </form>
</div>

</body>
</html>
