<?php
include("db/cn2.php"); // Include database connection
include("common/tx.php"); 
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//session_start(); // Start session

if ($_POST) {
    // Securely fetch POST data
    $name = isset($_POST["name"]) ? mysqli_real_escape_string($connection, $_POST["name"]) : '';
    $password = isset($_POST["password"]) ? $_POST["password"] : '';

    // Validate input
    if (empty($name) || empty($password)) {
        echo "Please provide both username and password.";
        exit();
    }

    // Query the database
    $query = "SELECT name, password, role, outlet_name, outlet_address FROM r_login WHERE name='$name'";
    $result = mysqli_query($connection, $query);

    // Check if user exists
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        // Determine if password is plaintext or hashed
        $storedPassword = $row['password'];

        // Use password_verify if the stored password is hashed
        $isPasswordValid = password_verify($password, $storedPassword) || $password === $storedPassword;

        if ($isPasswordValid) {
            // Store user information in session variables
            $_SESSION['user_name'] = $row['name'];
            $_SESSION['user_role'] = $row['role'];
            $_SESSION['outlet_name'] = $row['outlet_name'];
            $_SESSION['outlet_address'] = $row['outlet_address'];

            // Redirect based on role
            if ($row['role'] === 'superadmin') {
               echo '<script type="text/javascript">window.location.href="dashboard.php";</script>';
                exit();
            } elseif ($row['role'] === 'admin') {
                echo '<script type="text/javascript">window.location.href="mainpos.php";</script>';
                exit();
            } else {
                echo "Unknown role";
            }
        } else {
            echo "Invalid password";
        }
    } else {
        echo "User not found";
    }
} else {
    echo "";
}
ob_end_flush(); // End output buffering
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
</head>

<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
.bg-gradient-primary {
    background: linear-gradient(270deg, #060606, #0A4A5D);
    background-repeat: no-repeat;
    background-size: cover;
    background-attachment: fixed;
}

.btn-primary {
    background-color: #0A4A5D;
    color: #fff;
    border: none;
}

.btn-primary:hover {
    background: #fff;
    color: #0A4A5D;
    border: 1px solid #0A4A5D;
}

.logo-container {
    display: inline-block;
    animation: heartbeat 5s infinite;
}

@keyframes heartbeat {
    0% {
        transform: scale(1);
    }

    50% {
        transform: scale(1.1);
    }

    100% {
        transform: scale(1);
    }
}
</style>

<body class="bg-gradient-primary">
    <div class="container" style="margin-top:100px;">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12 col-md-9">
                <div class="card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="p-5">
                                    <div class="text-center text-uppercase" style="font-weight:700;">
                                        <h1 class="h4 text-gray-900 mb-4" style="font-weight:700;"><?php echo $tx; ?></h1>
                                    </div>
                                    <form class="user" action="index.php" method="post" enctype="multipart/form-data">
                                        <div class="form-group">
                                            <input type="text" class="form-control form-control-user" name="name"
                                                placeholder="Login Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="password" class="form-control form-control-user" name="password"
                                                placeholder="Password">
                                        </div>
                                        <div class="form-group">
                                            <div class="custom-control custom-checkbox small">
                                                <input type="checkbox" class="custom-control-input" id="customCheck">
                                                <label class="custom-control-label" for="customCheck">Remember Me</label>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-user btn-block">
                                            Login
                                        </button>
                                    </form>
                                </div>
                            </div>
                            <div class="col-lg-6 d-none d-lg-block text-center">
                                <br><br>
                                <div class="logo-container">
                                    <img src="../img/logo231.png" class="img-fluid" width="200">
                                </div>
                                <br><br><br>
                                <p style="color:#000; font-size:16px; font-weight:600;">Powered By <span style="color:#A67A00; font-size:16px; font-weight:700;">ATR Sales & Marketing Services</span></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
</body>

</html>
