<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include("db/cn.php");
include("common/tx.php");
ob_start();
if(isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

// Fetch filter parameters from the form
$supplier = isset($_POST['supplier']) ? $_POST['supplier'] : '';
$company = isset($_POST['company']) ? $_POST['company'] : '';
$product = isset($_POST['product']) ? $_POST['product'] : '';
$company_category = isset($_POST['company_category']) ? $_POST['company_category'] : '';
$startDate = isset($_POST['startDate']) ? $_POST['startDate'] : '';
$endDate = isset($_POST['endDate']) ? $_POST['endDate'] : '';

// Fetch supplier, company, category, and product data for form select options
$rec_suplier_name = mysqli_query($connection, "SELECT supplier FROM products GROUP BY supplier");
$rec_suplier_company = mysqli_query($connection, "SELECT company FROM products GROUP BY company");
$rec_suplier_company_category = mysqli_query($connection, "SELECT category FROM products GROUP BY category");
$rec_products = mysqli_query($connection, "SELECT product_name FROM products GROUP BY product_name");

// Base SQL query for totals
$sql_totals = "SELECT 
            SUM(quantity) AS total_quantity, 
            SUM(total_amount) AS total_amount 
        FROM 
            products 
        WHERE 1";

// Add filters based on selected options
if (!empty($supplier)) {
    $sql_totals .= " AND supplier = '" . mysqli_real_escape_string($connection, $supplier) . "'";
}

if (!empty($company)) {
    $sql_totals .= " AND company = '" . mysqli_real_escape_string($connection, $company) . "'";
}

if (!empty($company_category)) {
    $sql_totals .= " AND category = '" . mysqli_real_escape_string($connection, $company_category) . "'";
}
if (!empty($product)) {
    $sql_totals .= " AND product_name = '" . mysqli_real_escape_string($connection, $product) . "'";
}
if (!empty($startDate) && !empty($endDate)) {
    $sql_totals .= " AND date_time BETWEEN '" . mysqli_real_escape_string($connection, $startDate) . "' AND '" . mysqli_real_escape_string($connection, $endDate) . "'";
}

// Execute the query
$sum_result = mysqli_query($connection, $sql_totals);
$row = mysqli_fetch_assoc($sum_result);

// Check if the keys exist before accessing them
$total_quantity = isset($row['total_quantity']) ? $row['total_quantity'] : 0;
$total_amount = isset($row['total_amount']) ? $row['total_amount'] : 0;

// Prevent division by zero if $total_quantity is zero
$final = ($total_quantity != 0) ? ($total_amount / $total_quantity) : "Undefined";

// Main query for displaying products
$sql_products = "SELECT * FROM products WHERE 1";

if (!empty($supplier)) {
    $sql_products .= " AND supplier = '" . mysqli_real_escape_string($connection, $supplier) . "'";
}

if (!empty($company)) {
    $sql_products .= " AND company = '" . mysqli_real_escape_string($connection, $company) . "'";
}

if (!empty($company_category)) {
    $sql_products .= " AND category = '" . mysqli_real_escape_string($connection, $company_category) . "'";
}
if (!empty($product)) {
    $sql_products .= " AND product_name = '" . mysqli_real_escape_string($connection, $product) . "'";
}
if (!empty($startDate) && !empty($endDate)) {
    $sql_products .= " AND date_time BETWEEN '" . mysqli_real_escape_string($connection, $startDate) . "' AND '" . mysqli_real_escape_string($connection, $endDate) . "'";
}

$rec_purchases = mysqli_query($connection, $sql_products);



// Assuming you have a valid connection to the database in $connection
$query = mysqli_query($connection, "SELECT * FROM products");

// Initialize total sum variable
$total_sum = 0;

// Fetch rows from the query result set
while ($row = mysqli_fetch_assoc($query)) {
    // Multiply quantity by trade_price and add to total sum
    $total_sum += (int)$row['total_amount'] ;

    // Echo the result for each row if needed
    echo '';
}

// Output the final total sum

ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.btn, .form-control, tr{
	  	font-weight:700;
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                  <div class="container-fluid ">
     <div class="row">
        <div class="col-sm-3">
    <h3 style="font-weight:700; color:#060606;">Inventory Report</h3>
        </div>
        <div class="col-sm-6"></div>
        <div class="col-sm-3">
        
        </div>
    </div>

    <br>
    
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="supplier">Supplier Name:</label>
                    <select class="form-control" name="supplier">
                        <option value="">Select Supplier</option>
                        <?php while ($row_supplier_name = mysqli_fetch_array($rec_suplier_name)) { ?>
                            <option value="<?php echo $row_supplier_name['supplier']; ?>" <?php if($supplier == $row_supplier_name['supplier']) echo 'selected'; ?>>
                                <?php echo $row_supplier_name['supplier']; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="company">Supplier Company:</label>
                    <select class="form-control" name="company">
                        <option value="">Select Company</option>
                        <?php while ($row_supplier_company = mysqli_fetch_array($rec_suplier_company)) { ?>
                            <option value="<?php echo $row_supplier_company['company']; ?>" <?php if($company == $row_supplier_company['company']) echo 'selected'; ?>>
                                <?php echo $row_supplier_company['company']; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
           
            <div class="col-md-3">
                <div class="form-group">
                    <label for="company_category">Category:</label>
                    <select class="form-control" name="company_category">
                        <option value="">Select Category</option>
                        <?php while ($row_supplier_category = mysqli_fetch_array($rec_suplier_company_category)) { ?>
                            <option value="<?php echo $row_supplier_category['category']; ?>" <?php if($company_category == $row_supplier_category['category']) echo 'selected'; ?>>
                                <?php echo $row_supplier_category['category']; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
             <div class="col-md-3">
                <div class="form-group">
                    <label for="product">Product Name:</label>
                    <select class="form-control" name="product">
                        <option value="">Select Product</option>
                        <?php while ($row_products = mysqli_fetch_array($rec_products)) { ?>
                            <option value="<?php echo $row_products['product_name']; ?>" <?php if($product == $row_products['product_name']) echo 'selected'; ?>>
                                <?php echo $row_products['product_name']; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
        </div>
                
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label for="startDate">Start Date:</label>
                    <input type="date" class="form-control" name="startDate" value="<?php echo $startDate; ?>">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label for="endDate">End Date:</label>
                    <input type="date" class="form-control" name="endDate" value="<?php echo $endDate; ?>">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                   
                    <button type="submit" class="btn btn-dark " name="filter" style="margin-top:30px;">Filter</button>
                    <button id="downloadExcel" type='button' class="btn btn-dark " style="margin-top:30px;">Download </button>
                    <a href="report_i.php"><button type="button" class="btn btn-dark" style="margin-top:30px;"><i class="fas fa-sync-alt fa-1x"></i></button></a>
<button id="downloadPdf" type='button' class="btn btn-danger " style="margin-top:30px;"><i class="fas fa-file fa-1x"></i> Download Pdf</button>
                </div>
            </div>
        </div>
        
        <div id='report'>
            <div class="col-sm-12 " id="table-container-wrapper">
            <table id="patientTable" class="table table-stripped table-hover text-center table-sm bg-white">
                <thead>
                    <tr class="bg-dark text-white">
                        <th>Date</th>
                        <th>Supplier</th>
                        <th>Company</th>
                        <th>Category</th>
                        <th>Product Name</th>
                        <th>T.P</th>
                        <th>Total Quantity</th>
                        <th>Total Amount (Rs)</th>
                    </tr>
                </thead>
                    
                <tbody>
                    <?php while ($row = mysqli_fetch_array($rec_purchases)) { ?>
                        <tr style="color:#060606;">
                            <td><?php echo $row['date_time']; ?></td>
                            <td class="text-capitalize"><?php echo $row['supplier']; ?></td>
                            <td class="text-capitalize"><?php echo $row['company']; ?></td>
                            <td class="text-capitalize"><?php echo $row['category']; ?></td>
                            <td class="text-capitalize"><?php echo $row['product_name']; ?></td>
                            <td><?php echo $row['trade_price']; ?></td> 
                            <td><?php echo $row['quantity']; ?></td>
                            <td><?php echo (int)$row['total_amount']; ?> </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <div class="row">
            <div class="col-sm-12">
         
                <table class="table bg-white" style="color:#060606;">
                
                    <tfoot>
                        <tr>
                            <th>Total Quantity:</th>
                            <td><?php echo number_format($total_quantity); ?></td>
                        </tr>
                        <tr>
                            <th>Total Amount:</th>
                            <td>Rs <?php echo $total_sum; ?>
 /-</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        </div>
    
</div>

             


    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Patients" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Inventory_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
    
    
    document.getElementById("downloadPdf").addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const report = document.getElementById("report");

    // Get current date & time
    const now = new Date();
    const formattedDateTime = now.toLocaleDateString() + " " + now.toLocaleTimeString();

    html2canvas(report, { scale: 2 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF("p", "mm", "a4");
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

        // Add report image shifted down for header
        pdf.addImage(imgData, "PNG", 0, 30, pdfWidth, pdfHeight);

        // === Header text ===
        pdf.setFont("helvetica", "bold");
        pdf.setFontSize(14);
        pdf.text("Inventory Report", pdfWidth / 2, 12, { align: "center" });

        // Optional: Add print timestamp
        pdf.setFontSize(10);
        pdf.setFont("helvetica", "normal");
        pdf.text(`Printed: ${formattedDateTime}`, pdfWidth - 10, 20, { align: "right" });

        pdf.save("Inventory-Report.pdf");
    });
});
    
</script>  
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>