<?php
include("db/cn.php");
include("comon/tx.php");
ob_start();
if(isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Massive Seeds</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/sb-admin-2.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body { font-family: 'Quicksand', sans-serif; }
        .chart-container { position: relative; background: rgba(255, 255, 255, 0.9); border-radius: 10px; padding: 15px; box-shadow: 0 0 10px rgba(0,0,0,0.2); }
        canvas { max-width: 100%; height: auto; }
        .bg-gradient-primary{ background:#0A4657; color:#fff; }
        .btn-primary{ background:#0A4657; color:#fff; border:1px #0A4657 solid; }
        .btn-primary:hover{ background:#fff; border:1px #0A4657 solid; color:#0A4657; }
        .fa-download:hover{ color:#953E39; }
        #table-container-wrapper{ max-height:460px; overflow-y:auto; }
        tr{ font-weight:500; }
        .form-control,.btn, tr{ font-weight:700; }
    </style>
</head>

<body id="page-top">
<div id="wrapper">
    <?php include("common/sd.php"); ?>
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">
                <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3"><i class="fa fa-bars"></i></button>
                <?php include('common/log.php'); ?>
            </nav>

       <!-- ✅ Add Courier Charges Section -->
<div class="container-fluid mt-5">
    <h3 style="color:#060606;font-weight:700;">Processing Charges</h3>
    <div class="row justify-content-center mt-4">
        <div class="col-md-6">
            <div class="card shadow p-4">
                <form method="POST" action="">
                    <div class="form-group">
                        <label for="order_id">INV ID:</label>
                        <input type="text" name="order_id" id="order_id" class="form-control" placeholder="Enter Order ID" required>
                    </div>
                    <div class="form-group mt-3">
                        <label for="charges">Processing Charges:</label>
                        <input type="number" step="0.01" name="charges" id="charges" class="form-control" placeholder="Enter Charges Amount" required>
                    </div>
                    <button type="submit" name="add_courier" class="btn btn-dark mt-3 w-100">Processing Charges</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
// ✅ Handle courier charge submission
if (isset($_POST['add_courier'])) {
    $order_id = trim($_POST['order_id']);
    $charges = floatval($_POST['charges']);

    if (!empty($order_id) && $charges > 0) {
        // Update query: subtract charges from discount_amount and set charges value
        $updateQuery = "UPDATE purchase 
                        SET expence = ? 
                        WHERE inv_id = ?";
        $stmt = $connection->prepare($updateQuery);
        $stmt->bind_param("ds", $charges, $order_id);
        
        if ($stmt->execute()) {
            echo "<script>
                    alert('Courier charges have been added successfully.');
                    window.location.href = 'add_cour.php';
                  </script>";
        } else {
            echo "<script>alert('Error: Unable to update courier charges.');</script>";
        }
        $stmt->close();
    } else {
        echo "<script>alert('Please enter a valid Order ID and Charges.');</script>";
    }
}
?>

            </div>
            <?php include("common/main_ft.php"); ?>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script src="../vendor/jquery/jquery.min.js"></script>
<script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
<script src="../js/sb-admin-2.min.js"></script>
</body>
</html>
