<?php
include("../db/cn.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); 
 
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];

$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId' AND status='' AND r_order_id=''";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];

        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerName = $order['customer_name'];
        $preAmount = $order['pre_amount'];
        $grandAmount= $order['grand_amount'];
        $customerAddress = $order['customer_id'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
    }
}


?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice - Massive Seed Corporation</title>
<link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@400;600&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Quicksand', sans-serif;
    margin: 20px 40px;
    color: #000;
    font-size: 14px;
}
.header {
    text-align: center;
    border-bottom: 2px solid #000;
    padding-bottom: 10px;
    margin-bottom: 10px;
}
.header h2 {
    margin: 0;
    font-weight: 700;
    text-transform: uppercase;
}
.header p { margin: 3px 0; }

.top-row {
    display: flex;
    justify-content: space-between;
    margin-top: 10px;
}
.left-info, .right-info {
    width: 48%;
    font-size: 14px;
}
.right-info {
    text-align: right;
}
.right-box {
    border: 1px solid #000;
    padding: 5px;
    width: 60%;
    float: right;
    font-size: 13px;
    text-align: left;
}
.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
}
.table th, .table td {
    border: 1px solid #000;
    padding: 6px;
    text-align: center;
}
.summary-row {
    display: flex;
    justify-content: space-between;
    margin-top: 25px;
}
.box {
    border: 1px solid #000;
    padding: 5px;
    width: 40%;
}
.box2 {
    border: 1px solid #000;
    padding: 5px;
    width: 100%;
}
.footer {
    margin-top: 40px;
    border-top: 1px solid #000;
    padding-top: 10px;
    display: flex;
    justify-content: space-between;
    font-size: 14px;
}
.footer-left {
    width: 55%;
}
.footer-right {
    width: 40%;
    direction: rtl;
    text-align: right;
    font-family: 'Noto Nastaliq Urdu', 'Jameel Noori Nastaleeq', serif;
    font-size: 15px;
}
.footer-right ul {
    list-style-type: "• ";
    padding-right: 20px;
    margin-top: 10px;
}
.footer p {
    margin: 8px 0;
}
.clearfix::after {
    content: "";
    display: table;
    clear: both;
}
.text-center {
    text-align: center;
}
.no-print { 
    margin-top: 20px; 
    text-align: center; 
}
@media print { 
    .no-print { display: none; } 
}
</style>
</head>
<body>

<div class="header">
   <div style="float:left;"> 
       <img src="../img/logo231.png" width="110" height="110" style="border-radius:10px;"> 
   </div>
    <h2>Massive Seed Corporation Pvt Ltd</h2>
    <p>7 KM Multan Road Vehari</p>
    <p>0300-4075882 / 03400716475</p>
    <h4>Sales Invoice</h4>
</div>

<div class="top-row">
    <div class="left-info">
        <p><strong>INVOICE NO:</strong> <?php echo htmlspecialchars($orderId); ?></p>
        <p><strong>CUSTOMER:</strong> <?php echo htmlspecialchars($customerName); ?></p>
        <p><strong>ADDRESS:</strong> <?php echo htmlspecialchars($customerAddress); ?></p>
    </div>
    <div class="right-info">
        <p style="text-align:right;"><strong>Date:</strong> <?php echo htmlspecialchars($dateTime); ?></p>
        <div class="right-box">
            <p><strong>Contact #:</strong> <?php echo htmlspecialchars($customerPhone); ?></p>
           
        </div>
    </div>
</div>

<table class="table">
    <thead>
        <tr>
            <th>Products</th>
            <th>Quantity</th>
            <th>Rate</th>
             <th>PKR</th>
            <th>Dis. % </th>
            <th>Discount</th>
            <th>Amount</th>
            
        </tr>
    </thead>
    <tbody>
    <?php foreach ($orderDetails as $order): ?>
        <tr>
            <td><?php echo htmlspecialchars($order['product_name']); ?></td>
            <td><?php echo htmlspecialchars($order['product_quantity']); ?></td>
            <td><?php echo htmlspecialchars($order['product_price']); ?></td>
            <td><?php echo htmlspecialchars((int)$order['product_price'] * (int)$order['product_quantity']); ?></td>
            <td><?php echo htmlspecialchars($order['discount']); ?></td>
            <td><?php echo htmlspecialchars($order['disc_amount']); ?></td>
            <td><?php echo htmlspecialchars($order['net_amount']); ?></td>
            
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?php
$total_unit = 0;
$dis = 0;
$totaL = 0;
$pr = mysqli_query($connection,"select * from log_user_sales where order_id = '$orderId'");
while($r = mysqli_fetch_array($pr)){
    $total_unit += $r['product_quantity'];
    $totaL += $r['product_price'] * $r['product_quantity'] - $r['disc_amount'];
    $dis += $r['disc_amount'];
}
?>
<div class="summary-row">
    <div class="box">
        <p><strong>Previous BAL:</strong><?php echo number_format((int)$preAmount, 0); ?></p>
        <p><strong>Invoice Total:</strong> <?php echo number_format($discountedAmount, 0); ?></p>
        <p><strong>CURRENT BAL:</strong> <?php echo number_format($grandAmount, 0); ?></p>
    </div>

    <div class="box">
        <p><strong>Gross Amount:</strong> <?php echo number_format($totaL, 0); ?></p>
        <p><strong>Discount:</strong> <?php echo number_format($discounted, 0); ?></p>
        <p><strong>Net Amount:</strong> <?php echo number_format($discountedAmount, 0); ?></p>
    </div>
</div>

<p style="margin-top:10px;"><strong>Total Units:</strong> <?php echo (int)$total_unit ; ?></p>

<div class="box2" style="">
         <p><strong>STORE KEEPER:</strong> ______________________
        <strong>AUTHORIZED SIGN:</strong> ______________________
        <strong>VEHICLE NO:</strong> ______________________
        <strong>DRIVER'S NAME:</strong> ______________________<br>
        <strong>MOBILE:</strong> ______________________</p>
    </div>
<!-- ✅ FIXED FOOTER START -->
<div class="footer clearfix">
    <!-- Left (English) -->
    
    <div class="footer-left">
       
        <p><strong>RECEIVED BY:</strong> ______________________</p>
        <p><strong>SIGN & STAMP:</strong> ______________________</p>
    </div>

    <!-- Right (Urdu) -->
    <div class="footer-right" style="font-weight:600; font-size:17px;">
       <ul class="list-group" dir="rtl" style="text-align:right;">
        <li class="list-group-item">
            تمام پروڈکٹ صحیح حالت اور پوری مقدار میں وصول پائیں۔
        </li>
        <li class="list-group-item">
            لیک یا خراب پروڈکٹ کی اطلاع پانچ دن تک دیں۔
        </li>
        <li class="list-group-item">
            اکاؤنٹ بیلنس کی تصدیق کیلئے ہیڈ آفس رابطہ کریں۔
        </li>
</ul>

    </div>
</div>
<!-- ✅ FIXED FOOTER END -->

<h3 class="text-center" style="margin-top:40px;">Thank you for your business!</h3>

<div class="no-print">
    <button onclick="window.print()">🖨️ Print</button>
    <button onclick="window.location.href='order_detail_v.php'">Exit</button>
</div>

</body>
</html>
