<?php
include("../db/cn.php");
include("common/tx.php");
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Fetch order details from the database
$orderId = isset($_GET['order_id']) ? mysqli_real_escape_string($connection, $_GET['order_id']) : null;
$orderDetails = [];
$outletName = $loginUser = $userRole = $outletAddress = $dateTime = $totalAmount = $paidBy = $customerName = $customerPhone = $discountedAmount = $discounted = $discountPer = $cashAmount = $changeAmount = $taxAmount = null;

if ($orderId) {
    $query = "SELECT * FROM log_user_sales WHERE order_id = '$orderId'";
    $result = mysqli_query($connection, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $orderDetails = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $order = $orderDetails[0];
        $outletName = $order['outlet_name'];
        $loginUser = $order['login_user'];
        $userRole = $order['user_role'];
        $outletAddress = $order['outlet_address'];
        $dateTime = $order['date_time'];
        $totalAmount = $order['net_amount'];
        $paidBy = $order['paid_by'];
        $customerAddress = $order['customer_id'];
        $customerName = $order['customer_name'];
        $customerPhone = $order['customer_phone'];
        $discountedAmount = $order['discount_amount'];
        $discounted = $order['discounted'];
        $discountPer = $order['discount_per'];
        $cashAmount = $order['cash_amount'];
        $changeAmount = $order['change_amount'];
        $taxAmount = $order['tax_amount'];
        $pre = $order['pre_amount'];
        $close = $order['grand_amount'];
    }
}

$content = ob_get_clean();

function sendToPrinter($result) {
    $printerName = "EPSON_TM_T88V_Receipt";
    $handle = @fopen("USB", "w");
    if (!$handle) {
        echo "Error opening printer on Windows. Check the printer port and connection.";
        return;
    }
    fwrite($handle, $result);
    fclose($handle);
    echo "";
}

sendToPrinter($content);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?php echo $tx; ?></title>

<style>
    body {
        font-family: Arial, sans-serif;
        background: #fff;
        padding: 25px;
        font-size: 14px;
        color: #000;
        line-height: 1.4;
    }

    .invoice-container {
        width: 100%;
        max-width: 900px;
        margin: auto;
        background: #fff;
    }

    /* HEADER */
    .header {
        text-align: center;
        margin-bottom: 25px;
        padding-bottom: 10px;
        border-bottom: 2px solid #444;
    }

    .header img {
        width: 95px;
        margin-bottom: 8px;
        border-radius: 10px;
    }

    h2 {
        margin: 0;
        font-weight: 800;
        font-size: 22px;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .sub-header {
        font-size: 13px;
        margin-top: 6px;
        font-weight: 600;
        opacity: 0.8;
    }

    /* TOP BOXES */
    .top-info {
        display: flex;
        justify-content: space-between;
        margin-top: 25px;
    }

    .box {
        padding: 10px;
        border: 1px solid #666;
        width: 48%;
        font-size: 13px;
        background: #fafafa;
        border-radius: 6px;
    }

    /* TABLE */
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 18px;
        font-size: 13px;
    }

    th {
        background: #f0f0f0;
        font-weight: 700;
        padding: 8px;
        border: 1px solid #444;
    }

    td {
        padding: 7px;
        border: 1px solid #555;
    }

    tr:nth-child(even) {
        background: #fafafa;
    }

    tr:hover {
        background: #f5f5f5;
    }

    /* SUMMARY BOXES */
    .summary-boxes {
        display: flex;
        justify-content: space-between;
        margin-top: 20px;
    }

    .summary-left, .summary-right {
        width: 48%;
        border: 1px solid #666;
        padding: 12px;
        font-size: 13px;
        background: #fcfcfc;
        border-radius: 6px;
    }

    .summary-left strong,
    .summary-right strong {
        display: inline-block;
        width: 120px;
    }

    /* SIGNATURE SECTION */
    .signatures {
        border: 1px solid #666;
        padding: 12px;
        font-size: 13px;
        margin-top: 20px;
        background: #fafafa;
        border-radius: 6px;
        line-height: 2;
    }

    .received {
        margin-top: 25px;
        font-size: 13px;
        border-top: 1px dashed #777;
        padding-top: 15px;
    }

    /* URDU NOTES */
    .urdu-notes {
        text-align: right;
        font-size: 13px;
        margin-top: 25px;
        line-height: 1.7;
        border-right: 3px solid #444;
        padding-right: 10px;
        font-weight: 600;
    }

    /* BUTTONS */
    .print-buttons {
        text-align: center;
        margin: 30px 0;
    }

    .print-buttons button {
        padding: 8px 15px;
        border-radius: 5px;
        border: none;
        background: #222;
        color: #fff;
        cursor: pointer;
        font-size: 14px;
        margin: 5px;
    }

    .print-buttons button:hover {
        background: #444;
    }

    @media print {
        .no-print {
            display: none;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
    }
</style>


</head>
<body>

<div class="invoice-container">

    <!-- HEADER -->
    <div class="header">
               <!--<img src="../img/logo231.png" > -->

        <h2>MASSIVE Agri Research Farm</h2>
        <div class="sub-header">
            <!--7 KM Multan Road Vehari <br>-->
            <!--0300-4075982 / 0340-0716475 <br>-->
            <h3>Sales Invoice</h3>
        </div>
    </div>

    <!-- DATE & CUSTOMER BOXES -->
    <div class="top-info">
        <div class="box">
            <strong>INVOICE NO:</strong> <?= $orderId ?><br>
            <strong>CUSTOMER:</strong> <?= $customerName ?><br>
            <strong>ADDRESS:</strong> <?= $customerAddress ?>
        </div>

        <div class="box">
            <strong>Date:</strong> <?= $dateTime ?><br>
            <strong>Contact #:</strong> <?= $customerPhone ?><br>
        </div>
    </div>

    <!-- PRODUCT TABLE -->
    <table>
        <thead>
            <tr>
                <th>Products</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>PKR</th>
                <th>Dis. %</th>
                <th>Discount</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($orderDetails as $o): ?>
            <tr>
                <td><?= $o['product_name'] ?></td>
                <td><?= $o['product_quantity'] ?></td>
                <td><?= $o['product_price'] ?></td>
                <td><?= (int)$o['product_price'] * (int)$o['product_quantity'] ?></td>
                <td><?= $o['discount'] ?></td>
                <td><?= $o['disc_amount'] ?></td>
                <td><?= $o['net_amount'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- SUMMARY -->
    <div class="summary-boxes">
        <div class="summary-left">
            Previous BAL: <?= $pre ?><br>
            Invoice Total: <?= $discountedAmount ?><br>
            CURRENT BAL: <?= $close ?><br>
            Total Units: <?= count($orderDetails) ?>
        </div>

        <div class="summary-right">
            Gross Amount: <?= $discountedAmount ?><br>
            Discount: <?= $discounted ?><br>
            Net Amount: <?= $close ?><br>
        </div>
    </div>

    <!-- SIGNATURE AREA -->
    <div class="signatures">
        STORE KEEPER: ____________________  
        AUTHORIZED SIGN: ____________________  
        VEHICLE NO: ____________________  
        DRIVER'S NAME: ____________________  
        MOBILE: ____________________
    </div>

    <div style="margin-top:25px;">
        RECEIVED BY: ____________________ <br><br>
        SIGN & STAMP: ____________________
    </div>

    <!-- Urdu Notes -->
    <div class="urdu-notes">
        • تمام فراہمی صحیح حالت اور پورے مقدار میں وصول یبل ہے۔<br>
        • اگر کوئی خرابی یا کمی ہو تو اس کی اطلاع پہنچنے کے 24 گھنٹے کے اندر دیں۔<br>
        • اگلی خریدی کیلئے نمائندے سے رابطہ کریں۔
    </div>

    <h3 style="text-align:center; margin-top:20px;">Thank you for your business!</h3>

    <div class="print-buttons no-print">
        <button onclick="window.print()">🖨 Print</button>
       
           <button onclick="window.location.href='mainpos.php'">Exit</button>
       
    </div>

</div>
</body>
</html>

