<?php
include("db/cn.php"); // Include your database connection
include("common/tx.php");

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Start session and initialize variables
ob_start();
if (!empty($_SESSION['user_name']) && !empty($_SESSION['user_role']) && !empty($_SESSION['outlet_name']) && !empty($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}
ob_end_flush();
$sr = 1;

// =======================
// BUILD FILTER QUERY
// =======================

$where = [];

if (!empty($_POST['expence'])) {
    $exp = mysqli_real_escape_string($connection, $_POST['expence']);
    $where[] = "name_detail = '$exp'";
}

if (!empty($_POST['startDate']) && !empty($_POST['endDate'])) {
    $start = mysqli_real_escape_string($connection, $_POST['startDate']);
    $end = mysqli_real_escape_string($connection, $_POST['endDate']);
    $where[] = "DATE(date_time) BETWEEN '$start' AND '$end'";
}

$finalWhere = "";
if (!empty($where)) {
    $finalWhere = "WHERE " . implode(" AND ", $where);
}

// =======================
// RUN FILTERED QUERY
// =======================

$query = "SELECT * FROM incash $finalWhere ORDER BY date_time ASC";
$ex = mysqli_query($connection, $query);

// CALCULATE TOTAL
$totalAmount = 0;
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
        <link href="../css/sb-admin-2.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
 #table-container-wrapper {
    max-height: 560px; /* Adjust the maximum height as needed */
    overflow-y: auto; /* Enable vertical scroll when content overflows */
}
.btn, .form-control, tr{
    font-weight:700;
}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
                   <div class="container-fluid mt-5">
         <div class="row">
        <div class="col-sm-5">
     <h3 style="color:#060606; font-weight:700;"> Expense Report</h3>
        </div>
        <div class="col-sm-4"></div>
        <div class="col-sm-3">
             
        </div>
    </div>
   <br>
   <?php
    $exp = mysqli_query($connection,"select * from exp_head");
   ?>
        <form method="post">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="supplier">Expense Head:</label>
                        <select class="form-control" name="expence" required>
                            <option value="">Select Head</option>
                            <?php
                            // Populate creditor names in the dropdown
                            while ($row = mysqli_fetch_assoc($exp)): ?>
                                <option style="color:#060606;" value="<?= $row['exp_name'] ?>"><?= $row['exp_name'] ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="startDate">Start Date:</label>
                        <input type="date" class="form-control" name="startDate" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="endDate">End Date:</label>
                        <input type="date" class="form-control" name="endDate" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        
                        <button type="submit" class="btn btn-dark" name="filter" style="margin-top:30px;">Filter</button>
                         <a href="report_exp.php"><button type="button" class="btn btn-dark"  style="margin-top:30px;"><i class="fas fa-sync-alt fa-1x"></i></button></a>
<button id="downloadExcel" type="button" class="btn btn-dark " style="margin-top:30px;">Download </button>
 <button id="downloadPdf" type="button" class="btn btn-danger"  style="margin-top:30px;"><i class="fas fa-file fa-1x"></i> Download Pdf</button>

                    </div>
                </div>
            </div>
        </form>
        <br>
        <div id='report'>
            <div class="col-sm-12" id="table-container-wrapper">
                <table id="patientTable" class="table table-striped table-hover text-center table-sm bg-wite">
                    <thead>
                    <tr class="bg-dark text-white">
                        <th>Sr#</th>
                        <th>Date</th>
                        <th>Expense Name</th>
                        <th>Description</th>
                        <th>Amount</th>
                    </tr>
                    </thead>
                   <tbody>
<?php while ($rw = mysqli_fetch_array($ex)) { ?>
    <tr style="color:#060606;">
        <td><?php echo $sr++; ?></td>
        <td><?php echo $rw['date_time']; ?></td>
        <td><?php echo $rw['name_detail']; ?></td>
        <td><?php echo $rw['desc_name']; ?></td>
        <td><?php echo $rw['amount']; ?></td>
    </tr>
<?php
    $totalAmount += $rw['amount'];
} ?>
</tbody>
                </table>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <table class="table bg-white" style="color:#060606;">
                        <tfoot>
<tr>
    <th>Final Balance:</th>
    <td><strong><?php echo number_format($totalAmount, 2); ?></strong></td>
</tr>
</tfoot>
                    </table>

                </div>
            </div>

    </div>
        </div>


    
            
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<!-- JavaScript for exporting the table data to Excel -->
<script>
    document.getElementById('downloadExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('patientTable');

        // Clean the table to avoid potential issues with hidden rows or formatting
        var clone = table.cloneNode(true); // Clone the table
        var rows = clone.querySelectorAll('tr');

        // Remove hidden or empty rows if necessary
        rows.forEach(function(row) {
            if (row.style.display === 'none' || row.innerText.trim() === '') {
                row.remove();
            }
        });

        // Convert the table into a worksheet using SheetJS
        var workbook = XLSX.utils.table_to_book(clone, { sheet: "Expence" });

        // Export the Excel file with a proper name
        try {
            XLSX.writeFile(workbook, 'Expence_data.xlsx');
        } catch (error) {
            console.error("Error while writing the file: ", error);
            alert("Error generating Excel file. Please check if the SheetJS library is properly loaded.");
        }
    });
    
    document.getElementById("downloadPdf").addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const report = document.getElementById("report");

    // Get current date & time
    const now = new Date();
    const formattedDateTime = now.toLocaleDateString() + " " + now.toLocaleTimeString();

    html2canvas(report, { scale: 2 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const pdf = new jsPDF("p", "mm", "a4");
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

        // Add report image shifted down for header
        pdf.addImage(imgData, "PNG", 0, 30, pdfWidth, pdfHeight);

        // === Header text ===
        pdf.setFont("helvetica", "bold");
        pdf.setFontSize(14);
        pdf.text("Expense Report", pdfWidth / 2, 12, { align: "center" });

        // Optional: Add print timestamp
        pdf.setFontSize(10);
        pdf.setFont("helvetica", "normal");
        pdf.text(`Printed: ${formattedDateTime}`, pdfWidth - 10, 20, { align: "right" });

        pdf.save("Expense-Report.pdf");
    });
});
    
</script>
      
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>