<?php
include("db/cn.php");
include("common/tx.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_SESSION['user_name']) && isset($_SESSION['user_role']) && isset($_SESSION['outlet_name']) && isset($_SESSION['outlet_address'])) {
    $userName = $_SESSION['user_name'];
    $userRole = $_SESSION['user_role'];
    $outlet_address = $_SESSION['outlet_address'];
    $outlet_name = $_SESSION['outlet_name'];
}

// Get Monthly and Annual Start/End Dates
$month_start = date("Y-m-01");
$month_end = date("Y-m-t");
$year_start = date("Y-01-01");
$year_end = date("Y-12-31");

// Calculate Monthly Sale Revenue (excluding refunds)
$monthly_revenue = 0;
$query = "SELECT discount_amount AS total_revenue 
          FROM log_user_sales 
          WHERE status = '' 
          AND r_order_id = '' 
          AND date_time BETWEEN '$month_start' AND '$month_end' GROUP BY order_id";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $monthly_revenue += $row['total_revenue'];
}

// Calculate Annual Sale Revenue (excluding refunds)
$annual_revenue = 0;
$query = "SELECT discount_amount AS total_revenue 
          FROM log_user_sales 
          WHERE status = '' 
          AND r_order_id = '' 
          AND date_time BETWEEN '$year_start' AND '$year_end' GROUP BY order_id";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $annual_revenue += $row['total_revenue'];
}

// Calculate Monthly Refunded Sale Revenue
$monthly_refunded_revenue = 0;
$query = "SELECT discount_amount AS total_refunds 
          FROM log_user_sales 
          WHERE status = 'refund' 
          AND date_time BETWEEN '$month_start' AND '$month_end' GROUP BY r_order_id";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $monthly_refunded_revenue += $row['total_refunds'];
}

// Calculate Annual Refunded Sale Revenue
$annual_refunded_revenue = 0;
$query = "SELECT discount_amount AS total_refunds 
          FROM log_user_sales 
          WHERE status = 'refund' 
          AND date_time BETWEEN '$year_start' AND '$year_end' GROUP BY r_order_id";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $annual_refunded_revenue += $row['total_refunds'];
}

// Calculate Monthly Sale Cost (excluding refunds)
$monthly_cost = 0;
$query = "SELECT sale_cost AS total_cost 
          FROM log_user_sales 
          WHERE status = '' 
          AND date_time BETWEEN '$month_start' AND '$month_end'";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $monthly_cost += $row['total_cost'];
}

// Calculate Annual Sale Cost (excluding refunds)
$annual_cost = 0;
$query = "SELECT sale_cost AS total_cost 
          FROM log_user_sales 
          WHERE status = '' 
          AND date_time BETWEEN '$year_start' AND '$year_end'";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $annual_cost += $row['total_cost'];
}

// Calculate Monthly Refunded Sale Cost
$monthly_refunded_cost = 0;
$query = "SELECT sale_cost AS total_refunded_cost 
          FROM log_user_sales 
          WHERE status = 'refund' 
          AND date_time BETWEEN '$month_start' AND '$month_end'";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $monthly_refunded_cost += $row['total_refunded_cost'];
}

// Calculate Annual Refunded Sale Cost
$annual_refunded_cost = 0;
$query = "SELECT sale_cost AS total_refunded_cost 
          FROM log_user_sales 
          WHERE status = 'refund' 
          AND date_time BETWEEN '$year_start' AND '$year_end' ";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $annual_refunded_cost += (int)$row['total_refunded_cost'];
}

// Calculate Monthly Expenses
$monthly_expenses = 0;
$query = "SELECT amount AS total_expenses 
          FROM incash 
          WHERE date_time BETWEEN '$month_start' AND '$month_end'";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $monthly_expenses += (int)$row['total_expenses'];
}

// Calculate Annual Expenses
$annual_expenses = 0;
$query = "SELECT amount AS total_expenses 
          FROM incash 
          WHERE date_time BETWEEN '$year_start' AND '$year_end'";
$result = $connection->query($query);
while ($row = $result->fetch_assoc()) {
    $annual_expenses += (int)$row['total_expenses'];
}

// Calculate Net Revenue (excluding refunds)
$monthly_net_revenue = $monthly_revenue -  $monthly_refunded_revenue;
$annual_net_revenue = $annual_revenue - $annual_refunded_revenue;

// Calculate Net Cost (excluding refunds)
$monthly_net_cost = $monthly_cost - $monthly_refunded_cost;
$annual_net_cost = $annual_cost - $annual_refunded_cost ;

// Calculate Net Profit
$monthly_net_profit = $monthly_net_revenue - $monthly_net_cost - $monthly_expenses;
$annual_net_profit = $annual_net_revenue - $annual_net_cost - $annual_expenses;

// Now echo this data in the respective card elements
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $tx; ?></title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<style>
body {
    font-family: 'Quicksand', sans-serif;
    
}
		    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
.bg-gradient-primary{
    
	background:#0A4657;
	color:#fff;	
	
	}

.btn-primary{
	background:#0A4657;
	color:#fff;
	 border:1px #0A4657 solid;
	
	}  
.btn-primary:hover{
  
  background:#fff;
  border:1px #0A4657 solid;
	color:#0A4657;
	
	}	 
    .chart-container {
      position: relative;
      background: rgba(255, 255, 255, 0.9);
      border-radius: 10px;
      padding: 15px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
    }

    canvas {
      max-width: 100%;
      height: auto;
    }
	
	.fa-download:hover{
		color:#953E39;
		}
		
.text-primary{
	  	
		}
  </style>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php
        include("common/sd.php");
		?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Search -->
                    
  <?php include('common/log.php');  ?>

                    <!-- Topbar Navbar -->
                    
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                
                
             <div class="container-fluid">
                     <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800" style="font-weight:700;">Dashboard</h1>
                        
                    </div>

                    <div class="container" style="background: linear-gradient(360deg, #060606, #0A4657); border:5px solid #E3EAEC; border-radius:20px;">
                    <div class="row">
                    <div class="col-sm-5"> 
                    <br>
                    <img style="border-radius: 50%;" src="../img/logo231.png" width="70" height="70">
                    <br><br>
                    <h3 class="mb-3 text-white" style="font-size:25px;font-weight:700;">Welcome Admin ,<br><?php echo $tx; ?></h3>
                    <p class="text-white btn btn-dark btn-sm">Logged In</p>
                    </div>
                    <div class="col-sm-2"></div>
                    <div class="col-sm-5">
                    
                    <img src="../img/school.png" width="596" height="371" class="img-fluid" />
                    </div>
                    </div>
                    
                    </div>        

<br><br>

                   <div class="container">
                     <div class="row">

<!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                                Sale Revenue(Monthly)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs.<?= number_format($monthly_net_revenue) ?>/-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x" style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                                Sale Revenue(Annual)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs.<?= number_format($annual_net_revenue) ?>/-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x" style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                   

                       



<!-- Sale Cost (Annual) Card Example -->
<div class="col-xl-3 col-md-6 mb-4">
    <div class="card border-left-dark shadow h-100 py-2">
        <div class="card-body">
            <div class="row no-gutters align-items-center">
                <div class="col mr-2">
                    <div class="text-xs font-weight-bold text-uppercase mb-1" style="font-size:13px;color:#0A4657;">
                        Sale Cost (Monthly)
                    </div>
                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                        Rs. <?= number_format($monthly_net_cost) ?> /-
                    </div>
                </div>
                <div class="col-auto">
                    <i class="fas fa-dollar-sign fa-2x" style="color:#0A4657;"></i>
                </div>
            </div>
        </div>
    </div>

</div>


<!-- Sale Cost (Annual) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1" style="font-size:13px;color:#0A4657;">
                                                Sale Cost (Annual)
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                Rs. <?= number_format($annual_net_cost) ?>/-
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x" style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
      </div>               
                     <div class="row">
                       
                    
                        
                         <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                                Expense (Monthly)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs.  <?= number_format((int)$monthly_expenses) ?> /-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar fa-2x " style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                               Expense (Annual)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs.<?= number_format(@(int)$annual_expenses) ?> /-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x " style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                               Net-Profit (Monthly)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs. <?= number_format(@(int)$monthly_net_profit) ?> /-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x " style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Earnings (Monthly) Card Example -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-dark shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-uppercase mb-1"  style="font-size:13px;color:#0A4657;">
                                               Net-Profit (Annual)</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rs. <?= number_format($annual_net_profit) ?> /-</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x " style="color:#0A4657;"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Requests Card Example -->
                        
                        
                     </div>
                     
                   </div>
                   
                   
              
                   <!--line graph-->
                   <div class="container" style="margin-bottom:80px;">
                    <div class="row">
                      <div class="col-sm-8 ">
                        <div class="chart-container">
                        <div>
                                <button class="btn btn-dark btn-sm" onclick="filterData(7)">7 Days</button>
                                <button class="btn btn-dark btn-sm" onclick="filterData(14)">14 Days</button>
                                <button class="btn btn-dark btn-sm" onclick="filterData(28)">28 Days</button>
                            </div>
                          <canvas class="col-sm-12" id="lineChart"></canvas>
                            
                        </div>
                      </div>
                      <div class="col-sm-4">
                         <div class="chart-container">
                           <canvas id="donutChart"></canvas>
                        </div>
                      </div>
                    </div>
                  </div>



                </div>
                <!-- /.container-fluid -->

            </div>
            <br><br>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include("common/main_ft.php");  ?>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Select "Logout" below if you are ready to end your current session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="">Logout</a>
                </div>
            </div>
        </div>
    </div>

        <?php
// Database connection (assuming $connection is already defined)
$start_of_month = date("Y-m-01");
$end_of_month = date("Y-m-t");

// Fetch daily sales data for the current month
$sales_query = mysqli_query($connection, "
    SELECT DATE(date_time) AS date, SUM(discount_amount) AS total_sales 
    FROM log_user_sales 
    WHERE date_time BETWEEN '$start_of_month' AND '$end_of_month'
    GROUP BY DATE(date_time)
");

$sales_data = [];
while ($row = mysqli_fetch_assoc($sales_query)) {
    $sales_data[$row['date']] = $row['total_sales'];
}

// Fetch daily purchase data for the current month
$purchases_query = mysqli_query($connection, "
    SELECT DATE(date_time) AS date, SUM(sale_cost) AS total_purchases 
    FROM log_user_sales 
    WHERE date_time BETWEEN '$start_of_month' AND '$end_of_month'
    GROUP BY DATE(date_time)
");

$purchases_data = [];
while ($row = mysqli_fetch_assoc($purchases_query)) {
    $purchases_data[$row['date']] = $row['total_purchases'];
}

// Pass data to JavaScript
$sales_data_json = json_encode($sales_data);
$purchases_data_json = json_encode($purchases_data);
?>
  <?php
// Database connection (assuming $connection is already defined)
$current_date_expense = date("Y-m-d");

// Get the first and last day of the current month
$start_of_month_expense = date("Y-m-01");
$end_of_month_expense = date("Y-m-t");

// Sales Query
$sales_query_expense = mysqli_query($connection, "
    SELECT SUM(discount_amount) AS total_sales_expense 
    FROM log_user_sales 
    WHERE date_time BETWEEN '$start_of_month_expense' AND '$end_of_month_expense'
");

$total_sales_expense = 0;
if ($sales_query_expense) {
    $sales_result_expense = mysqli_fetch_array($sales_query_expense);
    if ($sales_result_expense && isset($sales_result_expense['total_sales_expense'])) {
        $total_sales_expense = $sales_result_expense['total_sales_expense'];
    }
}

// Purchase Query
$purchases_query_expense = mysqli_query($connection, "
    SELECT SUM(sale_cost) AS total_purchases_expense 
    FROM log_user_sales 
    WHERE date_time BETWEEN '$start_of_month_expense' AND '$end_of_month_expense'
");

$total_purchases_expense = 0;
if ($purchases_query_expense) {
    $purchases_result_expense = mysqli_fetch_array($purchases_query_expense);
    if ($purchases_result_expense && isset($purchases_result_expense['total_purchases_expense'])) {
        $total_purchases_expense = $purchases_result_expense['total_purchases_expense'];
    }
}

// Expense Query
$expense_query_expense = mysqli_query($connection, "
    SELECT SUM(amount) AS total_expense_expense 
    FROM incash 
    WHERE date_time BETWEEN '$start_of_month_expense' AND '$end_of_month_expense'
");

$total_expense_expense = 0;
if ($expense_query_expense) {
    $expense_result_expense = mysqli_fetch_array($expense_query_expense);
    if ($expense_result_expense && isset($expense_result_expense['total_expense_expense'])) {
        $total_expense_expense = $expense_result_expense['total_expense_expense'];
    }
}

// Pass data to JavaScript
$sales_data_json_expense = json_encode($total_sales_expense);
$purchases_data_json_expense = json_encode($total_purchases_expense);
$expense_data_json_expense = json_encode($total_expense_expense);
?>  
</div>    
</body>
 <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script>
        // Retrieve PHP data
        var salesData = <?php echo $sales_data_json; ?>;
        var purchasesData = <?php echo $purchases_data_json; ?>;

        // Get the current date and first and last day of the current month
        var currentDate = new Date();
        var firstDay = new Date(currentDate.getFullYear(), currentDate.getMonth(), 1);
        var lastDay = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, 0);

        // Generate labels for the current month
        var labels = [];
        for (var d = new Date(firstDay); d <= lastDay; d.setDate(d.getDate() + 1)) {
            labels.push(d.toISOString().split('T')[0]);
        }

        // Function to filter data
        function filterData(days) {
            var endDate = new Date();
            var startDate = new Date();
            startDate.setDate(endDate.getDate() - days + 1); // Calculate start date based on days

            var filteredLabels = [];
            var filteredSalesData = [];
            var filteredPurchasesData = [];

            labels.forEach(function(label, index) {
                var currentDate = new Date(label);
                if (currentDate >= startDate && currentDate <= endDate) {
                    filteredLabels.push(label);
                    filteredSalesData.push(salesData[label] || 0);
                    filteredPurchasesData.push(purchasesData[label] || 0);
                }
            });

            // Update chart data
            myChart.data.labels = filteredLabels;
            myChart.data.datasets[0].data = filteredPurchasesData;
            myChart.data.datasets[1].data = filteredSalesData;
            myChart.update();
        }

        // Initial data for the line chart
        var initialSalesDataArray = [];
        var initialPurchasesDataArray = [];

        labels.forEach(function(label) {
            initialSalesDataArray.push(salesData[label] || 0);
            initialPurchasesDataArray.push(purchasesData[label] || 0);
        });

        // Data for the line chart
        var data = {
            labels: labels,
            datasets: [
                {
                    label: 'Purchase',
                    borderColor: 'rgba(80, 63, 46, 1)',
                    backgroundColor: 'rgba(80, 63, 46, 0.2)',
                    data: initialPurchasesDataArray,
                    fill: 'origin'
                },
                {
                    label: 'Sale',
                    borderColor: 'rgba(6, 8, 9, 1)',
                    backgroundColor: 'rgba(6, 8, 9, 0.2)',
                    data: initialSalesDataArray,
                    fill: 'origin'
                }
            ]
        };

        // Chart configuration
        var config = {
            type: 'line',
            data: data,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Purchase Vs Sale Report'
                    }
                },
                scales: {
                    x: {
                        type: 'category',
                        labels: labels
                    }
                },
                animation: {
                    duration: 2800, // 2 seconds
                    easing: 'easeInOutQuad'
                }
            }
        };

        // Create the chart
        var ctx = document.getElementById('lineChart').getContext('2d');
        var myChart = new Chart(ctx, config);
    </script>
  <script>
           // Retrieve PHP data
        var salesDataExpense = <?php echo $sales_data_json_expense; ?>;
        var purchasesDataExpense = <?php echo $purchases_data_json_expense; ?>;
        var expenseDataExpense = <?php echo $expense_data_json_expense; ?>;

        // Data for the doughnut chart
        var dataExpense = {
            labels: ['Expense', 'purchase', 'Sale'],
            datasets: [{
                data: [expenseDataExpense, purchasesDataExpense, salesDataExpense],
                backgroundColor: [
                    'rgba(180, 143, 106, 0.8)',
                    'rgba(120, 95, 70, 0.8)',
                    'rgba(80, 63, 46, 0.8)'
                ],
                hoverBackgroundColor: [
                    'rgba(180, 143, 106, 1)',
                    'rgba(120, 95, 70, 1)',
                    'rgba(80, 63, 46, 1)'
                ]
            }]
        };

        // Chart configuration
        var configExpense = {
            type: 'doughnut',
            data: dataExpense,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    },
                    title: {
                        display: true,
                        text: 'Expense, Purchase, and Sale Report'
                    }
                },
                animation: {
                    animateRotate: true,
                    animateScale: true,
                    duration: 2000, // 2 seconds
                    easing: 'easeInOutQuad'
                }
            }
        };

        // Create the chart
        var ctxExpense = document.getElementById('donutChart').getContext('2d');
        var myChartExpense = new Chart(ctxExpense, configExpense);
 
  </script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

</body>

</html>